/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers;

import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternalService;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.PortalAndRequestTypeFilter;
import com.atlassian.servicedesk.internal.feature.jira.project.ServiceDeskProjectService;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortalAndRequestTypeFilterCreator {
    private InternalPortalService portalService;
    private ServiceDeskProjectService sdProjectService;
    private RequestTypeInternalService requestTypeInternalService;

    @Autowired
    public PortalAndRequestTypeFilterCreator(InternalPortalService portalService, ServiceDeskProjectService sdProjectService, RequestTypeInternalService requestTypeInternalService) {
        this.portalService = portalService;
        this.sdProjectService = sdProjectService;
        this.requestTypeInternalService = requestTypeInternalService;
    }

    public PortalAndRequestTypeFilter getPortalAndRequestType(CheckedUser user, Integer portalId, Integer requestTypeId) {
        if (portalId == null) {
            return new PortalAndRequestTypeFilter();
        }
        Option<Pair<Portal, Project>> portalAndProject = this.getPortalAndProject(user, portalId);
        if (portalAndProject.isEmpty()) {
            return new PortalAndRequestTypeFilter();
        }
        Project project = (Project)((Pair)portalAndProject.get()).right();
        Portal portal = (Portal)((Pair)portalAndProject.get()).left();
        if (requestTypeId == null) {
            return new PortalAndRequestTypeFilter(portal, project, (Option<RequestType>)Option.none());
        }
        Either requestType = this.requestTypeInternalService.getRequestTypeById(user, requestTypeId, project);
        if (requestType.isLeft() || ((RequestType)requestType.right().get()).getPortalId() != (long)portalId.intValue()) {
            return new PortalAndRequestTypeFilter(portal, project, (Option<RequestType>)Option.none());
        }
        return new PortalAndRequestTypeFilter(portal, project, (Option<RequestType>)requestType.right().toOption());
    }

    private Option<Pair<Portal, Project>> getPortalAndProject(CheckedUser user, Integer portalId) {
        return Steps.begin((Option)this.portalService.getPortalById(user, (long)portalId).right().toOption()).then(portal -> this.sdProjectService.getProjectById(user, this.portalService.toPortalInternal((Portal)portal).getProjectId()).toOption()).yield(Pair::new);
    }
}

