/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.feature.customer.approvals.ApprovalListResponseAssembler;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.ApprovalListFilterModel;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.ApprovalListFilterModelParser;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.CustomerResponseProvider;
import com.atlassian.servicedesk.internal.rest.requests.ModelsRequest;
import com.atlassian.servicedesk.internal.rest.responses.ApprovalListResponse;
import io.atlassian.fugue.Either;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApprovalListResponseProvider
implements CustomerResponseProvider<ApprovalListResponse> {
    private final UserFactory userFactory;
    private final ApprovalListFilterModelParser approvalListFilterModelParser;
    private final ApprovalListResponseAssembler approvalListResponseAssembler;

    @Autowired
    public ApprovalListResponseProvider(UserFactory userFactory, ApprovalListFilterModelParser approvalListFilterModelParser, ApprovalListResponseAssembler approvalListResponseAssembler) {
        this.userFactory = userFactory;
        this.approvalListFilterModelParser = approvalListFilterModelParser;
        this.approvalListResponseAssembler = approvalListResponseAssembler;
    }

    @Override
    public Either<AnError, ApprovalListResponse> getResponse(ModelsRequest ctx) {
        return (Either)this.userFactory.getCheckedUser().fold(Either::left, user -> {
            ApprovalListFilterModel filterModel = this.approvalListFilterModelParser.parse((CheckedUser)user, ctx.getOptions().getApprovalListFilter());
            return Either.right((Object)this.approvalListResponseAssembler.getResponse((CheckedUser)user, filterModel));
        });
    }
}

