/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers;

import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.ApprovalListFilterModel;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.PortalAndRequestTypeFilter;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.PortalAndRequestTypeFilterCreator;
import com.atlassian.servicedesk.internal.feature.customer.request.list.ApprovalQueryType;
import com.atlassian.servicedesk.internal.rest.requests.ApprovalListFilterOptions;
import io.atlassian.fugue.Option;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApprovalListFilterModelParser {
    private final PortalAndRequestTypeFilterCreator portalAndRequestTypeFilterCreator;

    @Autowired
    public ApprovalListFilterModelParser(PortalAndRequestTypeFilterCreator portalAndRequestTypeFilterCreator) {
        this.portalAndRequestTypeFilterCreator = portalAndRequestTypeFilterCreator;
    }

    public ApprovalListFilterModel parse(CheckedUser user, ApprovalListFilterOptions options) {
        Integer queryPortalId = options.getPortalId();
        Integer queryRequestTypeId = options.getRequestTypeId();
        PortalAndRequestTypeFilter portalAndRequestTypeFilter = this.portalAndRequestTypeFilterCreator.getPortalAndRequestType(user, queryPortalId, queryRequestTypeId);
        Option filter2 = Option.option((Object)options.getFilter());
        ApprovalQueryType approvalQueryType = this.getApprovalQueryType(options.getApprovalQueryType());
        return new ApprovalListFilterModel(approvalQueryType, portalAndRequestTypeFilter.getPortal(), portalAndRequestTypeFilter.getRequestType(), (Option<String>)filter2, options.getSelectedPage());
    }

    public String getApprovalFilterValue(ApprovalQueryType queryType) {
        return queryType.value();
    }

    private ApprovalQueryType getApprovalQueryType(String queryType) {
        if (StringUtils.equalsIgnoreCase((String)queryType, (String)ApprovalQueryType.MY_HISTORY_APPROVAL.value())) {
            return ApprovalQueryType.MY_HISTORY_APPROVAL;
        }
        if (StringUtils.equalsIgnoreCase((String)queryType, (String)ApprovalQueryType.MY_PENDING_APPROVAL.value())) {
            return ApprovalQueryType.MY_PENDING_APPROVAL;
        }
        return ApprovalQueryType.MY_PENDING_APPROVAL;
    }
}

