/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.lookandfeel;

import com.atlassian.lookandfeel.ColorScheme;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.internal.feature.customer.portal.lookandfeel.Theme;
import com.atlassian.servicedesk.internal.feature.customer.portal.lookandfeel.ThemeStore;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Eithers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ThemeManager {
    private final ThemeStore themeStore;
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    public ThemeManager(ThemeStore themeStore, ErrorResultHelper errorResultHelper) {
        this.themeStore = themeStore;
        this.errorResultHelper = errorResultHelper;
    }

    public Theme createTheme(ColorScheme colorScheme) {
        Theme theme = new Theme(colorScheme);
        Integer id = this.themeStore.createTheme(theme);
        theme.setId(id);
        return theme;
    }

    public void deleteTheme(int themeId) {
        this.themeStore.deleteTheme(themeId);
    }

    public Either<AnError, Theme> getPortalTheme(int themeId) {
        Theme theme = this.themeStore.getPortalTheme(themeId);
        return Eithers.cond((theme != null ? 1 : 0) != 0, (Object)this.errorResultHelper.notFound404("sd.error.theme.not.found", new Object[0]).build(), (Object)theme);
    }
}

