/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.lookandfeel;

import io.atlassian.fugue.Option;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogoHandler {
    private static final Logger log = LoggerFactory.getLogger(LogoHandler.class);

    public static Option<String> encode(File file) {
        try {
            FileInputStream fileInputStream = FileUtils.openInputStream((File)file);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(fileInputStream.available() * 4 / 3 + 4);
            Base64OutputStream output = new Base64OutputStream((OutputStream)baos, true, -1, null);
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)output);
            output.flush();
            IOUtils.closeQuietly((OutputStream)output);
            return Option.some((Object)baos.toString());
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                String fileName = file.getAbsolutePath();
                log.debug("Could not encode image string at {}", (Object)fileName);
            }
            return Option.none();
        }
    }

    public static InputStream decode(String string) {
        return new Base64InputStream(IOUtils.toInputStream((String)string));
    }
}

