/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.portal.PortalService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class PortalServiceImpl
implements PortalService {
    private final InternalPortalService internalPortalService;
    private final UserFactory userFactory;

    @Autowired
    public PortalServiceImpl(InternalPortalService internalPortalService, UserFactory userFactory) {
        this.internalPortalService = internalPortalService;
        this.userFactory = userFactory;
    }

    public Either<AnError, Portal> getPortalForProject(ApplicationUser user, Project project) {
        Either userEither = this.userFactory.wrap(user);
        if (userEither.isLeft()) {
            return Either.left((Object)userEither.left().get());
        }
        CheckedUser checkedUser = (CheckedUser)userEither.right().get();
        return StepsConverters.olderEither(this.internalPortalService.getPortalByProject(checkedUser, project));
    }

    public Either<AnError, Portal> getPortalForId(ApplicationUser user, long portalId) {
        Either userEither = this.userFactory.wrap(user);
        if (userEither.isLeft()) {
            return Either.left((Object)userEither.left().get());
        }
        CheckedUser checkedUser = (CheckedUser)userEither.right().get();
        Either portalServiceResult = StepsConverters.olderEither(this.internalPortalService.getPortalById(checkedUser, portalId));
        if (portalServiceResult.isLeft()) {
            return Either.left((Object)portalServiceResult.left().get());
        }
        Portal portal = (Portal)portalServiceResult.right().get();
        return Either.right((Object)portal);
    }
}

