/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.internal.api.portal.PortalManager;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternalManager;
import io.atlassian.fugue.Either;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class PortalManagerImpl
implements PortalManager {
    private final ProjectManager projectManager;
    private final PortalInternalManager portalInternalManager;
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    public PortalManagerImpl(ProjectManager projectManager, PortalInternalManager portalInternalManager, ErrorResultHelper errorResultHelper) {
        this.projectManager = projectManager;
        this.portalInternalManager = portalInternalManager;
        this.errorResultHelper = errorResultHelper;
    }

    public Either<AnError, Portal> getPortalByProject(@Nonnull Project project) {
        return this.portalInternalManager.getPortalByProject(project).map(p -> p);
    }

    public Either<AnError, Portal> getPortalByProjectKey(@Nonnull String projectKey) {
        Project project = this.projectManager.getProjectByCurrentKey(projectKey);
        if (Objects.isNull(project)) {
            return Either.left((Object)this.errorResultHelper.badRequest400("sd.customerview.error.customerViewNotFound", new Object[0]).build());
        }
        return this.portalInternalManager.getPortalByProject(project).map(p -> p);
    }
}

