/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.lookandfeel.ColorScheme;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.api.commons.result.Unit;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.bootstrap.lifecycle.ServiceDeskComponentAccessor;
import com.atlassian.servicedesk.internal.api.ServiceDeskManager;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseLink;
import com.atlassian.servicedesk.internal.api.requesttype.group.RequestTypeGroupManager;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.ConfluenceKnowledgeBaseManager;
import com.atlassian.servicedesk.internal.feature.customer.portal.ImageColorSchemeGenerator;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalAvatarChangeRequest;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternal;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternalManager;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalLookAndFeelChangeRequest;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalQStore;
import com.atlassian.servicedesk.internal.feature.customer.portal.lookandfeel.LogoHandlerScala;
import com.atlassian.servicedesk.internal.feature.customer.portal.lookandfeel.Theme;
import com.atlassian.servicedesk.internal.feature.customer.portal.lookandfeel.ThemeManager;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeInternalManager;
import com.atlassian.servicedesk.internal.images.ImageFileQStore;
import com.atlassian.servicedesk.internal.utils.CacheUtil;
import com.atlassian.vcache.RequestCache;
import com.atlassian.vcache.VCacheFactory;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortalInternalManagerImpl
implements PortalInternalManager {
    private static final Logger logger = LoggerFactory.getLogger(PortalInternalManagerImpl.class);
    private static final int MAX_NAME_LENGTH = 255;
    private static final int MAX_DESC_LENGTH = 2048;
    private final ConfluenceKnowledgeBaseManager confluenceKnowledgeBaseManager;
    private final ErrorResultHelper errorResultHelper;
    private final PortalQStore portalQStore;
    private final RequestTypeGroupManager requestTypeGroupManager;
    private final ImageFileQStore imageFileQStore;
    private final RequestTypeInternalManager requestTypeInternalManager;
    private final I18nHelper i18nHelper;
    private final ThemeManager themeManager;
    private final RequestCache<Long, Option<PortalInternal>> portalIdToPortalCache;
    private final ImageColorSchemeGenerator imageColorSchemeGenerator;

    @Autowired
    public PortalInternalManagerImpl(ConfluenceKnowledgeBaseManager confluenceKnowledgeBaseManager, ErrorResultHelper errorResultHelper, PortalQStore portalQStore, RequestTypeInternalManager requestTypeManager, RequestTypeGroupManager requestTypeGroupManager, ImageFileQStore imageFileQStore, ThemeManager themeManager, VCacheFactory cacheFactory, I18nHelper i18nHelper, ImageColorSchemeGenerator imageColorSchemeGenerator) {
        this.confluenceKnowledgeBaseManager = confluenceKnowledgeBaseManager;
        this.errorResultHelper = errorResultHelper;
        this.portalQStore = portalQStore;
        this.requestTypeGroupManager = requestTypeGroupManager;
        this.imageFileQStore = imageFileQStore;
        this.requestTypeInternalManager = requestTypeManager;
        this.themeManager = themeManager;
        this.portalIdToPortalCache = cacheFactory.getRequestCache(CacheUtil.standardName(this, "portalIdToPortalCache"));
        this.i18nHelper = i18nHelper;
        this.imageColorSchemeGenerator = imageColorSchemeGenerator;
    }

    @Override
    public List<PortalInternal> getPortals() {
        return this.portalQStore.getAllPortals();
    }

    @Override
    public Either<AnError, PortalInternal> getPortalById(Long id) {
        Option portalInternalOption = (Option)this.portalIdToPortalCache.get((Object)id, () -> {
            logger.trace("Retrieving portal with id {} from DB and adding it to the portalIdToPortalCache CACHE", (Object)id);
            return this.portalQStore.getPortalById(id.intValue()).map(this::toPortalInternal);
        });
        return portalInternalOption.toRight(this::PORTAL_NOT_FOUND);
    }

    @Override
    public Either<AnError, PortalInternal> getPortalByKey(String key) {
        return this.portalQStore.getPortalByKey(key).toRight(this::PORTAL_NOT_FOUND);
    }

    @Override
    public Either<AnError, PortalInternal> getPortalByProject(Project project) {
        return this.portalQStore.getPortalByProjectId(project.getId()).toRight(this::PORTAL_NOT_FOUND);
    }

    @Override
    public Either<AnError, PortalInternal> getPortalByProjectId(long projectId) {
        return this.portalQStore.getPortalByProjectId(projectId).toRight(this::PORTAL_NOT_FOUND);
    }

    @Override
    public Either<AnError, Portal> deletePortal(Integer portalId) {
        Option<Portal> portalOption = this.portalQStore.getPortalById(portalId);
        return portalOption.map(portal -> {
            this.invalidateCacheWithId(Long.valueOf(portal.getId()));
            this.requestTypeInternalManager.getAllRequestTypes((Portal)portal).forEach(rt -> this.requestTypeInternalManager.deleteRequestType(rt.getId()));
            this.requestTypeGroupManager.deleteGroups((Portal)portal);
            this.clearPortalLogo((Portal)portal);
            this.clearPortalTheme((Portal)portal);
            this.portalQStore.deletePortal(portal.getId());
            return portal;
        }).toRight(this::PORTAL_NOT_FOUND);
    }

    @Override
    public Either<AnError, Portal> updatePortalName(Integer portalId, String name) {
        return Steps.begin(this.validateName(name)).then(validatedName -> {
            this.invalidateCacheWithId((long)portalId);
            return this.portalQStore.updateName(portalId, (String)validatedName).toRight(this::PORTAL_NOT_FOUND);
        }).yield((validatedName, portal) -> portal);
    }

    @Override
    public Either<AnError, Portal> updatePortalDesc(Integer portalId, String desc) {
        return Steps.begin(this.validateDescription(desc)).then(validatedDesc -> {
            this.invalidateCacheWithId((long)portalId);
            return this.portalQStore.updateDescription(portalId, (String)validatedDesc).toRight(this::PORTAL_NOT_FOUND);
        }).yield((validatedDesc, portal) -> portal);
    }

    @Override
    public Either<AnError, Portal> updatePortalLookAndFeel(Portal portal, PortalLookAndFeelChangeRequest change) {
        this.invalidateCacheWithId(Long.valueOf(portal.getId()));
        Either<AnError, Portal> updateResult = this.updatePortalLookAndFeelInternal(portal, change);
        LogoHandlerScala.clear(change.getTemporaryLogoId());
        return updateResult;
    }

    @Override
    public Either<AnError, Portal> updatePortalAvatar(Portal portal, PortalAvatarChangeRequest portalAvatarChange) {
        String imageData = portalAvatarChange.getBase64Image().replaceFirst("data:image/png;base64,", "");
        try {
            if (ImageIO.read(this.createInputStreamFromDataUri(imageData)) != null) {
                return this.setPortalAvatar(portal, imageData);
            }
            return Either.left((Object)this.IMAGE_INVALID_ERROR());
        }
        catch (IOException e) {
            return Either.left((Object)this.IMAGE_INVALID_ERROR());
        }
    }

    @Override
    public Either<AnError, Portal> addPortal(Project project) {
        return this.addPortal(this.buildPortalFromProject(project), project);
    }

    @Override
    public Either<AnError, Portal> addPortal(Portal portal, Project project) {
        return Steps.begin(this.validateForAdd(portal, project)).then(validatedPortal -> {
            Either portalEither = this.portalQStore.addPortal((Portal)validatedPortal).toRight(this::PORTAL_DB_CREATION_FAILURE);
            portalEither.forEach(newPortal -> this.invalidateCacheWithId(Long.valueOf(newPortal.getId())));
            return portalEither;
        }).yield((validatedPortal, newlyCreatedPortal) -> newlyCreatedPortal);
    }

    @Override
    public Either<AnError, List<PortalInternal>> getPortalsByConfluenceSpaceKey(String spaceKey) {
        List<ConfluenceKnowledgeBaseLink> kbLinksForSpaceKey = this.confluenceKnowledgeBaseManager.getKBLinksBySpaceKey(spaceKey);
        if (kbLinksForSpaceKey.isEmpty()) {
            AnError anError = this.errorResultHelper.internalServiceError500("sd.portal.error.no.link.found.for.space.key", new Object[]{spaceKey}).build();
            return Either.left((Object)anError);
        }
        ArrayList portals = Lists.newArrayList();
        ServiceDeskManager serviceDeskManager = ServiceDeskComponentAccessor.getServiceDeskManager();
        for (ConfluenceKnowledgeBaseLink link : kbLinksForSpaceKey) {
            Steps.begin((Either)serviceDeskManager.getServiceDeskById(link.getServiceDeskId())).then(serviceDesk -> this.getPortalByProjectId(serviceDesk.getProjectId())).yield((serviceDesk, portal) -> {
                portals.add(portal);
                return Unit.UNIT;
            });
        }
        return Either.right((Object)portals);
    }

    @Override
    public PortalInternal toPortalInternal(Portal portal) {
        return (PortalInternal)portal;
    }

    private void invalidateCacheWithId(Long id) {
        logger.trace("Invalidating portal with id {} from CACHE", (Object)id);
        this.portalIdToPortalCache.remove((Object)id);
    }

    private void clearPortalLogo(Portal portal) {
        this.toPortalInternal(portal).getLogoId().forEach(logoId -> {
            this.imageFileQStore.deleteImage((int)logoId);
            this.invalidateCacheWithId(Long.valueOf(portal.getId()));
            this.portalQStore.clearLogo(portal.getId());
        });
    }

    private Either<AnError, Portal> updatePortalLookAndFeelInternal(Portal portal, PortalLookAndFeelChangeRequest change) {
        if (!change.isEnableCustomLookAndFeel()) {
            if (change.getTemporaryLogoId() != null) {
                this.imageFileQStore.deleteImage(change.getTemporaryLogoId());
            }
            this.clearPortalLogo(portal);
            return this.clearPortalTheme(portal);
        }
        int newLogoId = change.getTemporaryLogoId();
        this.setPortalLogo(portal, newLogoId);
        return this.setPortalTheme(portal, this.imageColorSchemeGenerator.generate(newLogoId));
    }

    private Either<AnError, Portal> clearPortalTheme(Portal portal) {
        this.invalidateCacheWithId(Long.valueOf(portal.getId()));
        Option<Portal> updatedPortal = this.portalQStore.clearTheme(portal.getId());
        this.themeManager.deleteTheme(portal.getId());
        return updatedPortal.toRight(this::PORTAL_NOT_FOUND);
    }

    private void setPortalLogo(Portal portal, int newLogoId) {
        this.invalidateCacheWithId(Long.valueOf(portal.getId()));
        this.toPortalInternal(portal).getLogoId().forEach(this.imageFileQStore::deleteImage);
        this.portalQStore.setLogo(portal.getId(), newLogoId);
    }

    private Either<AnError, Portal> setPortalTheme(Portal portal, Option<ColorScheme> colorSchemeOption) {
        return (Either)colorSchemeOption.fold(() -> this.clearPortalTheme(portal), colorScheme -> {
            this.invalidateCacheWithId(Long.valueOf(portal.getId()));
            Theme theme = this.themeManager.createTheme((ColorScheme)colorScheme);
            return this.portalQStore.setTheme(portal.getId(), theme.getId()).toRight(this::PORTAL_NOT_FOUND);
        });
    }

    private InputStream createInputStreamFromDataUri(String base64Image) {
        return new ByteArrayInputStream(Base64.decodeBase64((String)base64Image));
    }

    private Either<AnError, Portal> setPortalAvatar(Portal portal, String base64Image) {
        this.invalidateCacheWithId(Long.valueOf(portal.getId()));
        this.toPortalInternal(portal).getLogoId().forEach(this.imageFileQStore::deleteImage);
        return Steps.begin((Either)this.imageFileQStore.storeBase64Image(base64Image).toRight(this::IMAGE_INVALID_ERROR)).then(imageId -> this.portalQStore.setLogo(portal.getId(), (int)imageId).toRight(this::PORTAL_NOT_FOUND)).yield((imageId, updatedPortal) -> updatedPortal);
    }

    private Either<AnError, Portal> validateForAdd(Portal portal, Project project) {
        return Steps.begin(this.validateNewPortalKey(portal)).then(withValidatedKey -> this.validateNewPortalForProject(portal, project)).yield((withValidatedKey, withValidatedProject) -> portal);
    }

    private Either<AnError, Portal> validateNewPortalKey(Portal portal) {
        return (Either)this.portalQStore.getPortalByKey(this.toPortalInternal(portal).getKey()).fold(() -> Either.right((Object)portal), preExistingPortal -> Either.left((Object)this.DUPLICATE_PORTAL_KEY()));
    }

    private Either<AnError, Portal> validateNewPortalForProject(Portal portal, Project project) {
        return (Either)this.portalQStore.getPortalByProjectId(project.getId()).fold(() -> Either.right((Object)portal), preExistingPortal -> Either.left((Object)this.DUPLICATE_PROJECT_PORTAL()));
    }

    private Portal buildPortalFromProject(Project project) {
        String name = project.getName();
        String description = this.i18nHelper.getText("sd.customerview.default.description", project.getName());
        long projectId = project.getId();
        String projectKey = project.getKey();
        String portalKey = projectKey.toLowerCase();
        boolean sendEmailNotifications = true;
        return new PortalInternal(0, portalKey, name, description, true, projectId, (Option<Integer>)Option.none(), (Option<Integer>)Option.none());
    }

    private Either<AnError, String> validateName(String portalName) {
        String nameTrimmed = StringUtils.trimToEmpty((String)portalName);
        if (StringUtils.isBlank((String)nameTrimmed)) {
            return Either.left((Object)this.errorResultHelper.badRequest400("sd.admin.details.name.error.empty", new Object[0]).build());
        }
        if (nameTrimmed.length() > 255) {
            return Either.left((Object)this.errorResultHelper.badRequest400("sd.admin.details.name.error.too.big", new Object[0]).build());
        }
        return Either.right((Object)nameTrimmed);
    }

    private Either<AnError, String> validateDescription(String portalDescription) {
        String descTrimmed = StringUtils.trimToEmpty((String)portalDescription);
        if (descTrimmed.length() > 2048) {
            return Either.left((Object)this.errorResultHelper.badRequest400("sd.admin.details.description.error.too.big", new Object[0]).build());
        }
        return Either.right((Object)descTrimmed);
    }

    private AnError PORTAL_NOT_FOUND() {
        return this.errorResultHelper.notFound404("sd.customerview.error.customerViewNotFound", new Object[0]).build();
    }

    private AnError DUPLICATE_PORTAL_KEY() {
        return this.errorResultHelper.badRequest400("sd.portal.error.duplicate.key", new Object[0]).build();
    }

    private AnError DUPLICATE_PROJECT_PORTAL() {
        return this.errorResultHelper.badRequest400("sd.portal.error.duplicate", new Object[0]).build();
    }

    private AnError PORTAL_DB_CREATION_FAILURE() {
        return this.errorResultHelper.internalServiceError500("sd.portal.error.create.database", new Object[0]).build();
    }

    private AnError IMAGE_INVALID_ERROR() {
        return this.errorResultHelper.anError(412, "sd.error.servicedesk.agent.portalsettings.image.invalid", new Object[0]);
    }
}

