/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.project.Project;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.feature.customer.portal.CustomerUserPickerPermissionService;
import com.atlassian.servicedesk.internal.feature.organization.member.CustomerOrganizationMemberManager;
import com.atlassian.servicedesk.internal.feature.reqparticipants.permission.RequestParticipantPermissionService;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerUserPickerPermissionServiceImpl
implements CustomerUserPickerPermissionService {
    private final RequestParticipantPermissionService requestParticipantPermissionService;
    private final CustomerOrganizationMemberManager customerOrganizationMemberManager;
    private final FeatureManager featureManager;

    @Autowired
    public CustomerUserPickerPermissionServiceImpl(RequestParticipantPermissionService requestParticipantPermissionService, CustomerOrganizationMemberManager customerOrganisationMemberManager, FeatureManager featureManager) {
        this.requestParticipantPermissionService = requestParticipantPermissionService;
        this.customerOrganizationMemberManager = customerOrganisationMemberManager;
        this.featureManager = featureManager;
    }

    @Override
    public boolean canSearchAllUsersOfProject(CheckedUser user, Project project, ServiceDesk serviceDesk) {
        return this.requestParticipantPermissionService.canSearchForAnyParticipantForProject(user, project, serviceDesk);
    }

    @Override
    public boolean canSearchAnyOrganizations(CheckedUser user, Project project) {
        return this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS) && this.customerOrganizationMemberManager.isMemberOfAnyOrganizationsInProject(user, project);
    }
}

