/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.approvals;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.pocketknife.api.customfields.service.CustomFieldException;
import com.atlassian.pocketknife.api.customfields.service.CustomFieldMetadata;
import com.atlassian.pocketknife.api.customfields.service.GlobalCustomFieldService;
import com.atlassian.servicedesk.internal.feature.customer.approvals.ApproversCustomFieldManager;
import io.atlassian.fugue.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApproversCustomFieldManagerImpl
implements ApproversCustomFieldManager {
    private static final Logger log = LoggerFactory.getLogger(ApproversCustomFieldManagerImpl.class);
    private final CustomFieldMetadata customFieldMetaData = CustomFieldMetadata.builder().fieldName("sd.approvals.default.approvers.customfield.name").fieldDescription("sd.approvals.default.approvers.customfield.desc").fieldType("com.atlassian.jira.plugin.system.customfieldtypes:multiuserpicker").build();
    private final GlobalCustomFieldService globalCustomFieldService;

    @Autowired
    public ApproversCustomFieldManagerImpl(GlobalCustomFieldService globalCustomFieldService) {
        this.globalCustomFieldService = globalCustomFieldService;
    }

    @Override
    public Option<CustomField> getOrCreateApproversCustomField() {
        try {
            CustomField cf = this.globalCustomFieldService.getGlobalCustomField(this.customFieldMetaData);
            return Option.option((Object)cf);
        }
        catch (CustomFieldException e) {
            log.error(e.getMessage());
            return Option.none();
        }
    }
}

