/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.approvals;

import com.atlassian.jira.config.ResolutionManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.plugin.workflow.AbstractWorkflowModuleDescriptor;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.servicedesk.internal.feature.customer.approvals.ApprovalWorkflowImporterHelper;
import com.atlassian.servicedesk.internal.feature.customer.approvals.ApproversCustomFieldManager;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.ConditionDescriptor;
import com.opensymphony.workflow.loader.ConditionsDescriptor;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.opensymphony.workflow.loader.RestrictionDescriptor;
import com.opensymphony.workflow.loader.ResultDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApprovalWorkflowImporterHelperImpl
implements ApprovalWorkflowImporterHelper {
    static final String APPROVER_FIELD_ID_META_KEY = "approval.field.id";
    static final String RESOLUTION_DECLINED_I18N = "sd.workflow.approval.resolution.declined";
    static final String DECLINE_POST_FUNCTION_KEY = "sd.approval.decline.post.function";
    static final String BLOCK_IN_PROGRESS_CONDITION_KEY = "sd.approval.block.condition";
    static final String UPDATE_ISSUE_FIELD_FUNCTION_PLUGIN_KEY = "com.atlassian.jira.plugin.system.workflow:update-issue-field-function";
    static final String BLOCK_IN_PROGRESS_APPROVAL_CONDITION_PLUGIN_KEY = "com.atlassian.servicedesk.approvals-plugin:block-inprogress-approval-condition";
    private static Logger logger = LoggerFactory.getLogger(ApprovalWorkflowImporterHelperImpl.class);
    private final ApproversCustomFieldManager approversCustomFieldManager;
    private final PluginAccessor pluginAccessor;
    private final I18nHelper.BeanFactory i18nBeanFactory;
    private final ApplicationProperties applicationProperties;
    private final ResolutionManager resolutionManager;

    @Autowired
    public ApprovalWorkflowImporterHelperImpl(ApproversCustomFieldManager approversCustomFieldManager, PluginAccessor pluginAccessor, I18nHelper.BeanFactory i18nBeanFactory, ApplicationProperties applicationProperties, ResolutionManager resolutionManager) {
        this.approversCustomFieldManager = approversCustomFieldManager;
        this.pluginAccessor = pluginAccessor;
        this.i18nBeanFactory = i18nBeanFactory;
        this.applicationProperties = applicationProperties;
        this.resolutionManager = resolutionManager;
    }

    @Override
    public void importApprovalWorkflowRelatedComponent(JiraWorkflow workflow) {
        Collection allActions = workflow.getAllActions();
        Option<CustomField> approverField = this.approversCustomFieldManager.getOrCreateApproversCustomField();
        if (approverField.isEmpty()) {
            return;
        }
        String approverFieldId = ((CustomField)approverField.get()).getId();
        for (ActionDescriptor actionDescriptor : allActions) {
            this.importApprovalRelatedComponents(actionDescriptor, workflow, approverFieldId);
        }
    }

    private void importApprovalRelatedComponents(ActionDescriptor actionDescriptor, JiraWorkflow jiraWorkflow, String approverFieldId) {
        this.replaceApproverFieldMetaAttribute(actionDescriptor, jiraWorkflow, approverFieldId);
        this.addApprovalBlockCondition(actionDescriptor, jiraWorkflow);
        this.addDeclinePostFunction(actionDescriptor, jiraWorkflow);
    }

    private void addDeclinePostFunction(ActionDescriptor actionDescriptor, JiraWorkflow jiraWorkflow) {
        if (actionDescriptor.getMetaAttributes().containsKey(DECLINE_POST_FUNCTION_KEY)) {
            ResultDescriptor unconditionalResult = actionDescriptor.getUnconditionalResult();
            List postFunctions = unconditionalResult.getPostFunctions();
            FunctionDescriptor setDeclineResolutionPostFunction = this.createDeclineResolutionPostFunction();
            if (setDeclineResolutionPostFunction != null) {
                postFunctions.add(0, setDeclineResolutionPostFunction);
            }
            this.cleanUpAttribute(actionDescriptor, DECLINE_POST_FUNCTION_KEY);
        }
    }

    private void addApprovalBlockCondition(ActionDescriptor actionDescriptor, JiraWorkflow jiraWorkflow) {
        if (actionDescriptor.getMetaAttributes().containsKey(BLOCK_IN_PROGRESS_CONDITION_KEY)) {
            ConditionDescriptor blockInProgressApprovalCondition;
            ConditionsDescriptor conditionsDescriptor;
            RestrictionDescriptor restrictionDescriptor = actionDescriptor.getRestriction();
            if (restrictionDescriptor == null) {
                restrictionDescriptor = new RestrictionDescriptor();
                actionDescriptor.setRestriction(restrictionDescriptor);
            }
            if ((conditionsDescriptor = restrictionDescriptor.getConditionsDescriptor()) == null) {
                conditionsDescriptor = DescriptorFactory.getFactory().createConditionsDescriptor();
                restrictionDescriptor.setConditionsDescriptor(conditionsDescriptor);
            }
            if ((blockInProgressApprovalCondition = this.createBlockInProgressApprovalCondition()) != null) {
                conditionsDescriptor.getConditions().add(blockInProgressApprovalCondition);
            }
            this.cleanUpAttribute(actionDescriptor, BLOCK_IN_PROGRESS_CONDITION_KEY);
        }
    }

    public void cleanUpAttribute(ActionDescriptor descriptor, String attr) {
        descriptor.getMetaAttributes().remove(attr);
    }

    private void replaceApproverFieldMetaAttribute(ActionDescriptor actionDescriptor, JiraWorkflow jiraWorkflow, String approverFieldId) {
        Collection stepDescriptors = jiraWorkflow.getStepsForTransition(actionDescriptor);
        for (StepDescriptor stepDescriptor : stepDescriptors) {
            if (!stepDescriptor.getMetaAttributes().containsKey(APPROVER_FIELD_ID_META_KEY)) continue;
            stepDescriptor.getMetaAttributes().put(APPROVER_FIELD_ID_META_KEY, approverFieldId);
        }
    }

    private ConditionDescriptor createBlockInProgressApprovalCondition() {
        AbstractWorkflowModuleDescriptor pluginModule = this.getWorkflowModule(BLOCK_IN_PROGRESS_APPROVAL_CONDITION_PLUGIN_KEY);
        if (pluginModule != null) {
            ConditionDescriptor conditionDescriptor = DescriptorFactory.getFactory().createConditionDescriptor();
            conditionDescriptor.setType("class");
            conditionDescriptor.getArgs().put("class.name", pluginModule.getImplementationClass().getName());
            return conditionDescriptor;
        }
        return null;
    }

    private FunctionDescriptor createDeclineResolutionPostFunction() {
        Option<String> resolutionId = this.getResolutionIdForDeclineResolution();
        if (resolutionId.isEmpty()) {
            return null;
        }
        AbstractWorkflowModuleDescriptor pluginModule = this.getWorkflowModule(UPDATE_ISSUE_FIELD_FUNCTION_PLUGIN_KEY);
        if (pluginModule != null) {
            FunctionDescriptor functionDescriptor = DescriptorFactory.getFactory().createFunctionDescriptor();
            functionDescriptor.setType("class");
            functionDescriptor.getArgs().put("class.name", pluginModule.getImplementationClass().getName());
            functionDescriptor.getArgs().putAll(MapBuilder.build((Object)"field.name", (Object)"resolution", (Object)"field.value", (Object)resolutionId.get()));
            return functionDescriptor;
        }
        return null;
    }

    private AbstractWorkflowModuleDescriptor getWorkflowModule(String moduleKey) {
        AbstractWorkflowModuleDescriptor moduleDescriptor = (AbstractWorkflowModuleDescriptor)this.pluginAccessor.getPluginModule(moduleKey);
        if (moduleDescriptor == null) {
            logger.warn("Could not retrieve workflow descriptor module for '%s'", (Object)moduleKey);
        }
        return moduleDescriptor;
    }

    private Option<String> getResolutionIdForDeclineResolution() {
        I18nHelper i18n = this.i18nBeanFactory.getInstance(this.applicationProperties.getDefaultLocale());
        Resolution resolution = this.resolutionManager.getResolutionByName(i18n.getText(RESOLUTION_DECLINED_I18N));
        if (resolution == null) {
            return Option.none();
        }
        return Option.some((Object)resolution.getId());
    }
}

