/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.approvals;

import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.feature.customer.approvals.ApprovalListProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.ApprovalListFilterModel;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.ApprovalListFilterModelParser;
import com.atlassian.servicedesk.internal.feature.customer.request.MultiPortalSearchResult;
import com.atlassian.servicedesk.internal.feature.customer.request.list.AllVisiblePortals;
import com.atlassian.servicedesk.internal.feature.customer.request.list.ApprovalListFilter;
import com.atlassian.servicedesk.internal.feature.customer.request.list.ApprovalQueryType;
import com.atlassian.servicedesk.internal.feature.customer.request.list.PortalRequestListUtil;
import com.atlassian.servicedesk.internal.feature.customer.request.list.PortalRequestTypeFilter;
import com.atlassian.servicedesk.internal.feature.customer.request.list.PortalsAndRequestTypesResult;
import com.atlassian.servicedesk.internal.feature.customer.request.list.RequestListPageResponse;
import com.atlassian.servicedesk.internal.feature.customer.request.list.RequestListProvider;
import com.atlassian.servicedesk.internal.feature.customer.request.list.TextSearchFilter;
import com.atlassian.servicedesk.internal.rest.responses.ApprovalListResponse;
import com.atlassian.servicedesk.internal.rest.responses.PortalRequestTypes;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApprovalListResponseAssembler {
    public static final int DEFAULT_RESULTS_PER_PAGE = 20;
    private final ApprovalListProvider approvalListProvider;
    private final RequestListProvider requestListProvider;
    private final ApprovalListFilterModelParser approvalListFilterModelParser;
    private final PortalRequestListUtil portalRequestListUtil;

    @Autowired
    public ApprovalListResponseAssembler(ApprovalListProvider approvalListProvider, RequestListProvider requestListProvider, ApprovalListFilterModelParser approvalListFilterModelParser, PortalRequestListUtil portalRequestListUtil) {
        this.approvalListProvider = approvalListProvider;
        this.requestListProvider = requestListProvider;
        this.approvalListFilterModelParser = approvalListFilterModelParser;
        this.portalRequestListUtil = portalRequestListUtil;
    }

    public ApprovalListResponse getResponse(CheckedUser user, ApprovalListFilterModel approvalListFilterModel) {
        AllVisiblePortals allVisiblePortals = this.requestListProvider.getAllVisiblePortals(user);
        List<PortalRequestTypes> portalRequestTypes = this.getAllPortalsAndRequestTypesForUser(user, allVisiblePortals);
        PortalRequestTypeFilter portalRequestTypeFilter = this.portalRequestListUtil.validateSelectedPortalAndRequestType(portalRequestTypes, approvalListFilterModel.getPortal(), approvalListFilterModel.getRequestTypes());
        String portalId = this.portalRequestListUtil.getPortalId(portalRequestTypeFilter);
        String requestTypeId = this.portalRequestListUtil.getRequestTypeId(portalRequestTypeFilter);
        MultiPortalSearchResult searchResult = this.getRequestsMatchingApprovalFilter(user, allVisiblePortals, approvalListFilterModel, portalRequestTypeFilter);
        RequestListPageResponse requestListPageResponse = this.portalRequestListUtil.getRequestListPageResponse(searchResult, 20);
        String approvalQueryFilterValue = this.approvalListFilterModelParser.getApprovalFilterValue(approvalListFilterModel.getApprovalQueryType());
        return new ApprovalListResponse(portalId, approvalQueryFilterValue, requestTypeId, (String)approvalListFilterModel.getFilter().getOrNull(), approvalListFilterModel.getPage(), requestListPageResponse.getResultsPerPage(), requestListPageResponse.getTotalResults(), requestListPageResponse.getTotalPages(), portalRequestTypes, requestListPageResponse.getRequests());
    }

    private List<PortalRequestTypes> getAllPortalsAndRequestTypesForUser(CheckedUser viewingUser, AllVisiblePortals allVisiblePortals) {
        ApprovalListFilter approvalListFilter = ApprovalListFilter.getBuilder().approvalQueryType(ApprovalQueryType.MY_HISTORY_APPROVAL).build();
        PortalsAndRequestTypesResult portalsAndRequestTypes = this.approvalListProvider.getPortalsAndRequestTypes(viewingUser, allVisiblePortals, approvalListFilter);
        return this.portalRequestListUtil.toPortalRequestTypesResponse(portalsAndRequestTypes);
    }

    private MultiPortalSearchResult getRequestsMatchingApprovalFilter(CheckedUser user, AllVisiblePortals allVisiblePortals, ApprovalListFilterModel filterModel, PortalRequestTypeFilter portalRequestTypeFilter) {
        PagerFilter pagerFilter = this.portalRequestListUtil.createPager(filterModel.getPage(), 20);
        ApprovalListFilter filter2 = ApprovalListFilter.getBuilder().text(TextSearchFilter.summaryAndIssueKeyFilter((String)filterModel.getFilter().getOrElse((Object)""))).approvalQueryType(filterModel.getApprovalQueryType()).portalRequestType(portalRequestTypeFilter).build();
        return this.approvalListProvider.getCustomerRequests(user, allVisiblePortals, filter2, pagerFilter);
    }
}

