/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.approvals;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.pocketknife.api.customfields.service.CustomFieldService;
import com.atlassian.pocketknife.api.persistence.PersistenceService;
import com.atlassian.servicedesk.internal.feature.customer.approvals.ApprovalPluginInfo;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApprovalCustomFieldHelper {
    private final PersistenceService persistenceService;
    private final CustomFieldService customFieldService;
    private final long GLOBAL_ENTITY_ID = 1L;

    @Autowired
    public ApprovalCustomFieldHelper(PersistenceService persistenceService, CustomFieldService customFieldService) {
        this.persistenceService = persistenceService;
        this.customFieldService = customFieldService;
    }

    public Option<CustomField> getApprovalCustomField() {
        String approvalResourceKey = ApprovalPluginInfo.APPROVAL_CUSTOM_FIELD_PLUGIN_KEY;
        String approvalEntityName = ApprovalPluginInfo.APPROVAL_GLOBAL_PROPERTY_ENTITY_NAME;
        Long id = this.persistenceService.getLong(approvalEntityName, Long.valueOf(1L), approvalResourceKey);
        if (id == null) {
            return Option.none();
        }
        CustomField field = this.customFieldService.getCustomField(id);
        if (field == null) {
            return Option.none();
        }
        return Option.some((Object)field);
    }
}

