/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.confluenceknowledgebase;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseLink;
import com.atlassian.servicedesk.internal.feature.confluenceknowledgebase.ConfluenceKBSearchLabelQStore;
import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import io.atlassian.fugue.Option;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfluenceKBSearchLabelQStoreImpl
implements ConfluenceKBSearchLabelQStore {
    private final DatabaseAccessor databaseAccessor;

    @Autowired
    public ConfluenceKBSearchLabelQStoreImpl(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
    }

    @Override
    public Option<String> addKBLabel(ServiceDesk serviceDesk, RequestType requestType, ConfluenceKnowledgeBaseLink confluenceKBLink, String label) {
        return (Option)this.databaseAccessor.runInTransaction(conn -> this.insertKBLabel(serviceDesk, requestType, confluenceKBLink, label, (DatabaseConnection)conn).flatMap(id -> this.getLabel((int)id, (DatabaseConnection)conn)));
    }

    private Option<Integer> insertKBLabel(ServiceDesk serviceDesk, RequestType requestType, ConfluenceKnowledgeBaseLink confluenceKBLink, String label, DatabaseConnection connection) {
        return Option.option((Object)connection.insert((RelationalPath)Tables.CONFLUENCE_KB_LABEL).set(Tables.CONFLUENCE_KB_LABEL.SERVICE_DESK_ID, (Object)serviceDesk.getId()).set(Tables.CONFLUENCE_KB_LABEL.FORM_ID, (Object)requestType.getId()).set(Tables.CONFLUENCE_KB_LABEL.CONFLUENCE_KBID, (Object)confluenceKBLink.getId()).set((Path)Tables.CONFLUENCE_KB_LABEL.LABEL, (Object)label).executeWithKey(Tables.CONFLUENCE_KB_LABEL.ID));
    }

    private Option<String> getLabel(int id, DatabaseConnection connection) {
        String label = (String)((SQLQuery)((SQLQuery)connection.select((Expression)Tables.CONFLUENCE_KB_LABEL.LABEL).from((Expression)Tables.CONFLUENCE_KB_LABEL)).where((Predicate)Tables.CONFLUENCE_KB_LABEL.ID.eq((Object)id))).fetchOne();
        return Option.option((Object)label);
    }

    @Override
    public List<String> addAllKBLabels(ServiceDesk serviceDesk, RequestType requestType, ConfluenceKnowledgeBaseLink confluenceKBLink, List<String> labels) {
        return (List)this.databaseAccessor.runInTransaction(conn -> {
            this.deleteAllKBLabelsWithConnection(serviceDesk, requestType, (DatabaseConnection)conn);
            if (!labels.isEmpty()) {
                this.batchInsertKbLabels(serviceDesk, requestType, confluenceKBLink, labels, (DatabaseConnection)conn);
            }
            return this.getAllInsertedKBLinks(serviceDesk, requestType, confluenceKBLink, (DatabaseConnection)conn);
        });
    }

    private List<String> getAllInsertedKBLinks(ServiceDesk serviceDesk, RequestType requestType, ConfluenceKnowledgeBaseLink confluenceKBLink, DatabaseConnection connection) {
        return ((SQLQuery)((SQLQuery)connection.select((Expression)Tables.CONFLUENCE_KB_LABEL.LABEL).from((Expression)Tables.CONFLUENCE_KB_LABEL)).where((Predicate)Tables.CONFLUENCE_KB_LABEL.SERVICE_DESK_ID.eq((Object)serviceDesk.getId()).and((Predicate)Tables.CONFLUENCE_KB_LABEL.FORM_ID.eq((Object)requestType.getId())).and((Predicate)Tables.CONFLUENCE_KB_LABEL.CONFLUENCE_KBID.eq((Object)confluenceKBLink.getId())))).fetch();
    }

    private long batchInsertKbLabels(ServiceDesk serviceDesk, RequestType requestType, ConfluenceKnowledgeBaseLink confluenceKBLink, List<String> labels, DatabaseConnection databaseConnection) {
        SQLInsertClause insertClause = databaseConnection.insert((RelationalPath)Tables.CONFLUENCE_KB_LABEL);
        labels.stream().forEach(label -> insertClause.set(Tables.CONFLUENCE_KB_LABEL.SERVICE_DESK_ID, (Object)serviceDesk.getId()).set(Tables.CONFLUENCE_KB_LABEL.FORM_ID, (Object)requestType.getId()).set(Tables.CONFLUENCE_KB_LABEL.CONFLUENCE_KBID, (Object)confluenceKBLink.getId()).set((Path)Tables.CONFLUENCE_KB_LABEL.LABEL, label).addBatch());
        long rowsInserted = insertClause.execute();
        if (rowsInserted != (long)labels.size()) {
            throw new RuntimeException("Expected number of rows " + labels.size() + " to be inserted does not match number of rows inserted " + rowsInserted);
        }
        return rowsInserted;
    }

    @Override
    public List<String> getAllKBLabels(ServiceDesk serviceDesk, RequestType requestType) {
        return (List)this.databaseAccessor.runInTransaction(conn -> this.getAllKBLabelsWithConnection(serviceDesk, requestType, (DatabaseConnection)conn));
    }

    private List<String> getAllKBLabelsWithConnection(ServiceDesk serviceDesk, RequestType requestType, DatabaseConnection connection) {
        return ((SQLQuery)((SQLQuery)connection.select((Expression)Tables.CONFLUENCE_KB_LABEL.LABEL).from((Expression)Tables.CONFLUENCE_KB_LABEL)).where((Predicate)Tables.CONFLUENCE_KB_LABEL.SERVICE_DESK_ID.eq((Object)serviceDesk.getId()).and((Predicate)Tables.CONFLUENCE_KB_LABEL.FORM_ID.eq((Object)requestType.getId())))).fetch();
    }

    @Override
    public List<String> getAllKBLabelsForRequestType(RequestType requestType) {
        return (List)this.databaseAccessor.runInTransaction(conn -> ((SQLQuery)((SQLQuery)conn.select((Expression)Tables.CONFLUENCE_KB_LABEL.LABEL).from((Expression)Tables.CONFLUENCE_KB_LABEL)).where((Predicate)Tables.CONFLUENCE_KB_LABEL.FORM_ID.eq((Object)requestType.getId()))).fetch());
    }

    @Override
    public List<String> removeKBAllLabels(ServiceDesk serviceDesk, RequestType requestType) {
        return (List)this.databaseAccessor.runInTransaction(conn -> {
            List<String> labels = this.getAllKBLabelsWithConnection(serviceDesk, requestType, (DatabaseConnection)conn);
            this.deleteAllKBLabelsWithConnection(serviceDesk, requestType, (DatabaseConnection)conn);
            return labels;
        });
    }

    private void deleteAllKBLabelsWithConnection(ServiceDesk serviceDesk, RequestType requestType, DatabaseConnection connection) {
        connection.delete((RelationalPath)Tables.CONFLUENCE_KB_LABEL).where((Predicate)Tables.CONFLUENCE_KB_LABEL.SERVICE_DESK_ID.eq((Object)serviceDesk.getId()).and((Predicate)Tables.CONFLUENCE_KB_LABEL.FORM_ID.eq((Object)requestType.getId()))).execute();
    }

    @Override
    public Option<String> removeKBLabel(ServiceDesk serviceDesk, RequestType requestType, String label) {
        return (Option)this.databaseAccessor.runInTransaction(conn -> {
            Option<String> databaseLabel = this.getKBLabel(serviceDesk, requestType, label, (DatabaseConnection)conn);
            this.deleteKBLabel(serviceDesk, requestType, label, (DatabaseConnection)conn);
            return databaseLabel;
        });
    }

    private Option<String> getKBLabel(ServiceDesk serviceDesk, RequestType requestType, String label, DatabaseConnection connection) {
        return Option.option((Object)((SQLQuery)((SQLQuery)connection.select((Expression)Tables.CONFLUENCE_KB_LABEL.LABEL).from((Expression)Tables.CONFLUENCE_KB_LABEL)).where((Predicate)Tables.CONFLUENCE_KB_LABEL.SERVICE_DESK_ID.eq((Object)serviceDesk.getId()).and((Predicate)Tables.CONFLUENCE_KB_LABEL.FORM_ID.eq((Object)requestType.getId())).and((Predicate)Tables.CONFLUENCE_KB_LABEL.LABEL.eq((Object)label)))).fetchOne());
    }

    private void deleteKBLabel(ServiceDesk serviceDesk, RequestType requestType, String label, DatabaseConnection connection) {
        connection.delete((RelationalPath)Tables.CONFLUENCE_KB_LABEL).where((Predicate)Tables.CONFLUENCE_KB_LABEL.SERVICE_DESK_ID.eq((Object)serviceDesk.getId()).and((Predicate)Tables.CONFLUENCE_KB_LABEL.FORM_ID.eq((Object)requestType.getId())).and((Predicate)Tables.CONFLUENCE_KB_LABEL.LABEL.eq((Object)label))).execute();
    }
}

