/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.confluenceknowledgebase;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseLink;
import com.atlassian.servicedesk.internal.feature.confluenceknowledgebase.ConfluenceKBEnabled;
import com.atlassian.servicedesk.internal.feature.confluenceknowledgebase.ConfluenceKBSearchEnabledQStore;
import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.querydsl.core.types.ConstructorExpression;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfluenceKBSearchEnabledQStoreImpl
implements ConfluenceKBSearchEnabledQStore {
    private DatabaseAccessor databaseAccessor;

    private static ConstructorExpression<ConfluenceKBEnabled> MAPPER() {
        return Projections.constructor(ConfluenceKBEnabled.class, (Expression[])new Expression[]{Tables.CONFLUENCE_KB_ENABLED.ID, Tables.CONFLUENCE_KB_ENABLED.CONFLUENCE_KBID, Tables.CONFLUENCE_KB_ENABLED.ENABLED, Tables.CONFLUENCE_KB_ENABLED.FORM_ID, Tables.CONFLUENCE_KB_ENABLED.SERVICE_DESK_ID});
    }

    @Autowired
    public ConfluenceKBSearchEnabledQStoreImpl(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
    }

    @Override
    public boolean setEnabled(ConfluenceKBEnabled confluenceKBEnabled, boolean enabled) {
        long numberOfRowsUpdated = (Long)this.databaseAccessor.runInTransaction(conn -> conn.update((RelationalPath)Tables.CONFLUENCE_KB_ENABLED).where((Predicate)Tables.CONFLUENCE_KB_ENABLED.ID.eq((Object)confluenceKBEnabled.getId())).set((Path)Tables.CONFLUENCE_KB_ENABLED.ENABLED, (Object)enabled).execute());
        if (numberOfRowsUpdated != 1L) {
            throw new RuntimeException(String.format("Expected %d row to be updated, but %d updated", 1, numberOfRowsUpdated));
        }
        return this.getKbEnabledById(confluenceKBEnabled.getId()).exists(Boolean::booleanValue);
    }

    @Override
    public boolean createEnabled(ServiceDesk serviceDesk, RequestType requestType, ConfluenceKnowledgeBaseLink confluenceKBLink, boolean enabled) {
        Integer id = (Integer)this.databaseAccessor.runInTransaction(conn -> (Integer)conn.insert((RelationalPath)Tables.CONFLUENCE_KB_ENABLED).set((Path)Tables.CONFLUENCE_KB_ENABLED.ENABLED, (Object)enabled).set(Tables.CONFLUENCE_KB_ENABLED.SERVICE_DESK_ID, (Object)serviceDesk.getId()).set(Tables.CONFLUENCE_KB_ENABLED.FORM_ID, (Object)requestType.getId()).set(Tables.CONFLUENCE_KB_ENABLED.CONFLUENCE_KBID, (Object)confluenceKBLink.getId()).executeWithKey(Tables.CONFLUENCE_KB_ENABLED.ID));
        return Option.option((Object)id).flatMap(this::getKbEnabledById).exists(Boolean::booleanValue);
    }

    @Override
    public boolean delete(ServiceDesk serviceDesk, RequestType requestType) {
        Option<ConfluenceKBEnabled> existingEnabled = this.findEnabled(serviceDesk, requestType);
        this.databaseAccessor.runInTransaction(conn -> conn.delete((RelationalPath)Tables.CONFLUENCE_KB_ENABLED).where((Predicate)Tables.CONFLUENCE_KB_ENABLED.SERVICE_DESK_ID.eq((Object)serviceDesk.getId()).and((Predicate)Tables.CONFLUENCE_KB_ENABLED.FORM_ID.eq((Object)requestType.getId()))).execute());
        return existingEnabled.exists(ConfluenceKBEnabled::isEnabled);
    }

    @Override
    public boolean isEnabled(ServiceDesk serviceDesk, RequestType requestType) {
        Option<ConfluenceKBEnabled> enabled = this.findEnabled(serviceDesk, requestType);
        return (Boolean)enabled.map(ConfluenceKBEnabled::isEnabled).getOrElse((Object)true);
    }

    @Override
    public Option<ConfluenceKBEnabled> findEnabled(ServiceDesk serviceDesk, RequestType requestType) {
        ConfluenceKBEnabled kbEnabled = (ConfluenceKBEnabled)this.databaseAccessor.runInTransaction(conn -> (ConfluenceKBEnabled)((SQLQuery)((SQLQuery)conn.select(ConfluenceKBSearchEnabledQStoreImpl.MAPPER()).from((Expression)Tables.CONFLUENCE_KB_ENABLED)).where((Predicate)Tables.CONFLUENCE_KB_ENABLED.SERVICE_DESK_ID.eq((Object)serviceDesk.getId()).and((Predicate)Tables.CONFLUENCE_KB_ENABLED.FORM_ID.eq((Object)requestType.getId())))).fetchFirst());
        return Option.option((Object)kbEnabled);
    }

    private Option<Boolean> getKbEnabledById(int id) {
        Boolean enabled = (Boolean)this.databaseAccessor.runInTransaction(conn -> (Boolean)((SQLQuery)((SQLQuery)conn.select((Expression)Tables.CONFLUENCE_KB_ENABLED.ENABLED).from((Expression)Tables.CONFLUENCE_KB_ENABLED)).where((Predicate)Tables.CONFLUENCE_KB_ENABLED.ID.eq((Object)id))).fetchFirst());
        return Option.option((Object)enabled);
    }
}

