/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.announcement;

import com.google.common.base.MoreObjects;
import io.atlassian.fugue.Option;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;

@ParametersAreNonnullByDefault
public class Announcement {
    private final Option<String> header;
    private final Option<String> message;

    private static String extractText(Option<String> option) {
        return (String)option.filter(StringUtils::isNotBlank).getOrElse((Object)"");
    }

    private Announcement(Option<String> header, Option<String> message) {
        this.header = header;
        this.message = message;
    }

    @Nonnull
    public Option<String> getHeader() {
        return this.header;
    }

    @Nonnull
    public String getHeaderAsText() {
        return Announcement.extractText(this.header);
    }

    @Nonnull
    public Option<String> getMessage() {
        return this.message;
    }

    @Nonnull
    public String getMessageAsText() {
        return Announcement.extractText(this.message);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("header", this.header).add("message", this.message).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Announcement)) {
            return false;
        }
        Announcement that = (Announcement)o;
        return this.header.equals(that.header) && this.message.equals(that.message);
    }

    public int hashCode() {
        int result = this.header.hashCode();
        result = 31 * result + this.message.hashCode();
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Option<Announcement> announcement) {
        return Announcement.builder((Announcement)announcement.getOrNull());
    }

    public static Builder builder(@Nullable Announcement announcement) {
        return new Builder(announcement);
    }

    @ParametersAreNonnullByDefault
    public static class Builder {
        private Option<String> header = Option.none();
        private Option<String> message = Option.none();

        private Builder() {
        }

        private Builder(@Nullable Announcement announcement) {
            if (announcement != null) {
                this.header = announcement.header;
                this.message = announcement.message;
            }
        }

        public Builder header(@Nullable String header) {
            this.header((Option<String>)Option.option((Object)header));
            return this;
        }

        public Builder header(Option<String> header) {
            this.header = header;
            return this;
        }

        public Builder message(@Nullable String message) {
            this.message((Option<String>)Option.option((Object)message));
            return this;
        }

        public Builder message(Option<String> message) {
            this.message = message;
            return this;
        }

        public Announcement build() {
            return new Announcement(this.header, this.message);
        }
    }
}

