/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.event;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.servicedesk.internal.api.customfield.CustomFieldTypeChecker;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserChangeLogValueExtractor {
    private final CustomFieldTypeChecker customFieldTypeChecker;

    @Autowired
    public UserChangeLogValueExtractor(CustomFieldTypeChecker customFieldTypeChecker) {
        this.customFieldTypeChecker = customFieldTypeChecker;
    }

    public List<String> extractUserKeys(CustomField customField, @Nullable String changeLogValue) {
        if (StringUtils.isBlank((String)changeLogValue)) {
            return Collections.emptyList();
        }
        return this.getListOfUsers(customField, changeLogValue);
    }

    private List<String> getListOfUsers(CustomField customField, String changeLogValue) {
        if (this.customFieldTypeChecker.isRequestParticipantsCustomField(customField)) {
            return this.getListOfUsersForRequestParticipant(changeLogValue);
        }
        if (this.customFieldTypeChecker.isSingleUserCustomField(customField)) {
            return this.getListOfUsersForSingleUser(changeLogValue);
        }
        if (this.customFieldTypeChecker.isMultiUserCustomField(customField)) {
            return this.getListOfUsersForMultiUsers(changeLogValue);
        }
        return Collections.emptyList();
    }

    private List<String> getListOfUsersForMultiUsers(String changeLogValue) {
        if (changeLogValue.length() < 2) {
            return Collections.emptyList();
        }
        String valueString = changeLogValue.substring(1, changeLogValue.length() - 1);
        return Arrays.asList(valueString.split(",")).stream().map(user -> user.trim()).collect(Collectors.toList());
    }

    private List<String> getListOfUsersForSingleUser(String changeLogValue) {
        return Lists.newArrayList((Object[])new String[]{changeLogValue});
    }

    private List<String> getListOfUsersForRequestParticipant(String changeLogValue) {
        return Arrays.asList(changeLogValue.split(",")).stream().map(user -> user.trim()).collect(Collectors.toList());
    }
}

