/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.event;

import com.atlassian.jira.event.issue.IssueChangedEvent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.util.FieldPredicates;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.events.UserChangeItemBeanUtils;
import com.atlassian.servicedesk.internal.api.events.UsersAddedToCustomField;
import com.atlassian.servicedesk.internal.event.UserChangeLogValueExtractor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Maybe;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class UserChangeItemBeanUtilsImpl
implements UserChangeItemBeanUtils {
    private static Logger logger = LoggerFactory.getLogger(UserChangeItemBeanUtilsImpl.class);
    private final IssueManager issueManager;
    private final UserManager userManager;
    private final UserFactory userFactory;
    private final UserChangeLogValueExtractor userChangeLogValueExtractor;

    @Autowired
    public UserChangeItemBeanUtilsImpl(IssueManager issueManager, UserManager userManager, UserFactory userFactory, UserChangeLogValueExtractor userChangeLogValueExtractor) {
        this.issueManager = issueManager;
        this.userManager = userManager;
        this.userFactory = userFactory;
        this.userChangeLogValueExtractor = userChangeLogValueExtractor;
    }

    public Option<UsersAddedToCustomField> findNewlyAddedUsersFromIssueEvent(Collection<ChangeItemBean> changeItemBeans, CustomField customField) {
        if (!FieldPredicates.isCustomUserField().evaluate((Object)customField)) {
            logger.debug(String.format("Custom Field %s is not a User Custom Field", customField.getFieldName()));
            return Option.none();
        }
        return this.findAddedUserPerCustomField(customField, changeItemBeans);
    }

    public List<UsersAddedToCustomField> findNewlyAddedUsersFromIssueEvent(IssueEvent issueEvent, Collection<CustomField> customFields) {
        Collection validUserCustomFields = customFields.stream().filter(cf -> FieldPredicates.isCustomUserField().evaluate(cf)).collect(Collectors.toList());
        if (validUserCustomFields.isEmpty()) {
            return Collections.emptyList();
        }
        List<ChangeItemBean> changeItemBeans = this.getChangeItemBeans(issueEvent);
        return this.findAddedUsers(customFields, changeItemBeans);
    }

    public List<UsersAddedToCustomField> findNewlyAddedUsersFromIssueChangeEvent(IssueChangedEvent issueChangedEvent, Collection<CustomField> customFields) {
        Collection validUserCustomFields = customFields.stream().filter(cf -> FieldPredicates.isCustomUserField().evaluate(cf)).collect(Collectors.toList());
        if (validUserCustomFields.isEmpty()) {
            return Collections.emptyList();
        }
        Collection changeItemBeans = issueChangedEvent.getChangeItems();
        return this.findAddedUsers(customFields, (List<ChangeItemBean>)ImmutableList.copyOf((Collection)changeItemBeans));
    }

    private List<UsersAddedToCustomField> findAddedUsers(Collection<CustomField> validUserCustomFields, List<ChangeItemBean> changeItemBeans) {
        if (changeItemBeans.isEmpty()) {
            return Collections.emptyList();
        }
        List<UsersAddedToCustomField> usersAddedToCustomFields = validUserCustomFields.stream().map(cf -> this.findAddedUserPerCustomField((CustomField)cf, (Collection<ChangeItemBean>)changeItemBeans)).filter(Maybe::isDefined).map(Maybe::get).collect(Collectors.toList());
        return usersAddedToCustomFields;
    }

    private Option<UsersAddedToCustomField> findAddedUserPerCustomField(CustomField customField, Collection<ChangeItemBean> changeItemBeans) {
        if (changeItemBeans.isEmpty()) {
            return Option.none();
        }
        Optional<UsersAddedToCustomField> addedUserPerCustomField = changeItemBeans.stream().filter(changeItem -> Objects.equals(customField.getFieldName(), changeItem.getField())).map(changeItem -> this.findAddedUsers(customField, (ChangeItemBean)changeItem)).filter(addedUsers -> !addedUsers.isEmpty()).map(addedUsers -> new UsersAddedToCustomField(customField, addedUsers)).findFirst();
        return Option.fromOptional(addedUserPerCustomField);
    }

    @VisibleForTesting
    List<CheckedUser> findAddedUsers(CustomField customField, ChangeItemBean changeItem) {
        List<String> fromUsers = this.userChangeLogValueExtractor.extractUserKeys(customField, changeItem.getFrom());
        List<String> toUsers = this.userChangeLogValueExtractor.extractUserKeys(customField, changeItem.getTo());
        List<String> addedUserKeys = this.getAddedUserKeys(fromUsers, toUsers);
        return this.toCheckedUsers(addedUserKeys);
    }

    private List<String> getAddedUserKeys(List<String> fromUsers, List<String> toUsers) {
        return toUsers.stream().filter(userKey -> !fromUsers.contains(userKey)).collect(Collectors.toList());
    }

    private List<CheckedUser> toCheckedUsers(List<String> addedUserKeys) {
        return addedUserKeys.stream().map(addedUserKey -> this.userFactory.wrapUserKey(addedUserKey).toOption()).filter(com.atlassian.fugue.Maybe::isDefined).map(com.atlassian.fugue.Maybe::get).collect(Collectors.toList());
    }

    private List<ChangeItemBean> getChangeItemBeans(IssueEvent issueEvent) {
        GenericValue changeLog = issueEvent.getChangeLog();
        if (changeLog == null) {
            return Collections.emptyList();
        }
        ChangeHistory changeHistory = new ChangeHistory(issueEvent.getChangeLog(), this.issueManager, this.userManager);
        return changeHistory.getChangeItemBeans();
    }
}

