/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.email.replystripping.rules.factory;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.ozymandias.PluginPointFunction;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.pocketknife.spi.emailreply.matcher.QuotedEmailMatcher;
import com.atlassian.servicedesk.internal.email.replystripping.rules.factory.EmailReplyMatcherModuleDescriptor;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
@Component
public class EmailReplyMatcherModuleManager {
    private final PluginAccessor pluginAccessor;

    @Autowired
    public EmailReplyMatcherModuleManager(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public List<QuotedEmailMatcher> getQuotedEmailMatchers(Runnable successMatchedCallback) {
        PluginPointFunction callback = (moduleDescriptor, module) -> {
            AtomicBoolean hasError = new AtomicBoolean(false);
            return textBlock -> {
                if (hasError.get()) {
                    return false;
                }
                try {
                    boolean shouldStripText = module.shouldStripText(textBlock);
                    if (shouldStripText) {
                        successMatchedCallback.run();
                    }
                    return shouldStripText;
                }
                catch (Throwable e) {
                    hasError.set(true);
                    SafePluginPointAccess.handleException((Throwable)e, (ModuleDescriptor)moduleDescriptor, (Object)module);
                    return false;
                }
            };
        };
        return SafePluginPointAccess.to((PluginAccessor)this.pluginAccessor).forType(EmailReplyMatcherModuleDescriptor.class, callback);
    }
}

