/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.email.replystripping;

import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.mail.converters.HtmlConverter;
import com.atlassian.pocketknife.api.emailreply.EmailReplyCleaner;
import com.atlassian.pocketknife.api.emailreply.EmailReplyCleanerBuilder;
import com.atlassian.pocketknife.spi.emailreply.matcher.QuotedEmailMatcher;
import com.atlassian.servicedesk.internal.admin.EmailTrimmingMode;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsEvent;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsService;
import com.atlassian.servicedesk.internal.email.replystripping.MarkerBasedMatcher;
import com.atlassian.servicedesk.internal.email.replystripping.analytics.QuotedEmailDetectionEvent;
import com.atlassian.servicedesk.internal.email.replystripping.rules.factory.EmailReplyMatcherModuleManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Option;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.commons.lang.StringUtils;

@ParametersAreNonnullByDefault
class ServiceDeskEmailReplyCleaner
implements EmailReplyCleaner {
    private final EmailReplyCleaner pocketknifeCleaner;
    private final Option<MarkerBasedMatcher> markerBasedMatcher;
    private final AnalyticsService analyticsService;
    private final AtomicBoolean emailReplyMatcherModule;
    private final boolean sendAnalytics;

    ServiceDeskEmailReplyCleaner(EmailTrimmingMode emailTrimmingMode, Option<HtmlConverter> htmlConverterOption, AnalyticsService analyticsService, LocaleManager localeManager, I18nHelper.BeanFactory i18nHelperFactory, EmailReplyMatcherModuleManager emailReplyMatcherModuleManager) {
        this.analyticsService = analyticsService;
        if (emailTrimmingMode == EmailTrimmingMode.NONE) {
            this.markerBasedMatcher = Option.none();
            this.sendAnalytics = false;
        } else {
            this.markerBasedMatcher = Option.some((Object)this.createMarkerBasedMatcher(localeManager, i18nHelperFactory));
            this.sendAnalytics = true;
        }
        this.emailReplyMatcherModule = new AtomicBoolean(false);
        this.pocketknifeCleaner = this.createEmailReplyCleaner(emailReplyMatcherModuleManager, emailTrimmingMode, htmlConverterOption);
    }

    private EmailReplyCleaner createEmailReplyCleaner(EmailReplyMatcherModuleManager emailReplyMatcherModuleManager, EmailTrimmingMode emailTrimmingMode, Option<HtmlConverter> htmlConverterOption) {
        EmailReplyCleanerBuilder emailReplyCleanerBuilder = this.createBuilder();
        switch (emailTrimmingMode) {
            case NONE: {
                emailReplyCleanerBuilder.customMatchers((List)ImmutableList.of(list -> false));
                break;
            }
            case SMART: {
                emailReplyCleanerBuilder.defaultMatchers().customMatchers((List)ImmutableList.of((Object)this.markerBasedMatcher.getOrThrow(() -> new IllegalStateException("Marker Based Matcher is not defined"))));
                break;
            }
            case CUSTOM: {
                List<QuotedEmailMatcher> quotedEmailMatcherModules = emailReplyMatcherModuleManager.getQuotedEmailMatchers(() -> this.emailReplyMatcherModule.set(true));
                emailReplyCleanerBuilder.defaultMatchers().customMatchers((List)ImmutableList.of((Object)this.markerBasedMatcher.getOrThrow(() -> new IllegalStateException("Marker Based Matcher is not defined")))).customMatchers(quotedEmailMatcherModules);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown trimming mode value : " + (Object)((Object)emailTrimmingMode));
            }
        }
        return (EmailReplyCleaner)htmlConverterOption.fold(() -> ((EmailReplyCleanerBuilder)emailReplyCleanerBuilder).build(), converter -> emailReplyCleanerBuilder.preferHtml(converter).build());
    }

    @VisibleForTesting
    EmailReplyCleanerBuilder createBuilder() {
        return new EmailReplyCleanerBuilder();
    }

    @VisibleForTesting
    MarkerBasedMatcher createMarkerBasedMatcher(LocaleManager localeManager, I18nHelper.BeanFactory i18nHelperFactory) {
        return new MarkerBasedMatcher(localeManager, i18nHelperFactory);
    }

    @Nonnull
    public EmailReplyCleaner.EmailCleanerResult cleanQuotedEmail(Message message) throws IOException, MessagingException {
        EmailReplyCleaner.EmailCleanerResult cleanerResult;
        try {
            cleanerResult = this.pocketknifeCleaner.cleanQuotedEmail(message);
        }
        catch (IOException | MessagingException e) {
            this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new QuotedEmailDetectionEvent("servicedesk.action.email.reply.detection.error"));
            throw e;
        }
        if (this.sendAnalytics) {
            return this.processAnalyticsAndReturnResult(cleanerResult);
        }
        return cleanerResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EmailReplyCleaner.EmailCleanerResult processAnalyticsAndReturnResult(EmailReplyCleaner.EmailCleanerResult cleanerResult) {
        String eventName = "servicedesk.action.email.reply.detection.none";
        if (StringUtils.isBlank((String)cleanerResult.getRawBody())) {
            if (!StringUtils.isNotBlank((String)cleanerResult.getOriginalBody())) return cleanerResult;
            eventName = this.getQuotedEmailAnalyticsEventName();
        } else if (!StringUtils.equals((String)cleanerResult.getOriginalBody(), (String)cleanerResult.getBody())) {
            eventName = this.getQuotedEmailAnalyticsEventName();
        }
        this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new QuotedEmailDetectionEvent(eventName));
        return cleanerResult;
    }

    private String getQuotedEmailAnalyticsEventName() {
        if (this.markerBasedMatcher.exists(MarkerBasedMatcher::getMarkerDetected)) {
            return "servicedesk.action.email.reply.detection.marker";
        }
        if (this.emailReplyMatcherModule.get()) {
            return "servicedesk.action.email.reply.detection.custom";
        }
        return "servicedesk.action.email.reply.detection.pattern";
    }
}

