/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.email;

import com.atlassian.jira.util.I18nHelper;
import com.atlassian.mail.MailConstants;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailProtocol;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.impl.PopMailServerImpl;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.servicedesk.internal.email.SDMailServerManager;
import com.atlassian.servicedesk.internal.email.SDMailServiceError;
import com.atlassian.servicedesk.squalor.email.MailServerVerifier;
import com.atlassian.servicedesk.squalor.email.SDMailServerConnectionTestFailure;
import com.atlassian.servicedesk.squalor.email.SDMailServerConnectionTestSuccess;
import io.atlassian.fugue.Either;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SDMailServerManagerImpl
implements SDMailServerManager {
    protected final Log log = Log.with(this.getClass());
    private final MailServerManager mailServerManager;
    private final I18nHelper i18nHelper;

    @Autowired
    public SDMailServerManagerImpl(MailServerManager mailServerManager, I18nHelper i18nHelper) {
        this.mailServerManager = mailServerManager;
        this.i18nHelper = i18nHelper;
    }

    @Override
    public Either<SDMailServiceError, Long> deleteIncomingMailServer(@Nonnull Long mailServerId) {
        Either<SDMailServiceError, MailServer> eitherMailServer = this.getMailServerById(mailServerId);
        if (eitherMailServer.isLeft()) {
            return Either.left((Object)eitherMailServer.left().get());
        }
        try {
            this.mailServerManager.delete(mailServerId);
            return Either.right((Object)mailServerId);
        }
        catch (MailException e) {
            this.log.error("Failed to delete MailServer", new Object[]{e});
            return Either.left((Object)new SDMailServiceError("sd.mail.service.error.delete.server"));
        }
    }

    @Override
    public Either<SDMailServiceError, SDMailServerConnectionTestSuccess> verifyIncomingMailServerConnection(String name, String description, String protocol, String hostName, String port, String username, String password, Long timeout) {
        MailProtocol mailProtocol = this.getMailProtocol(protocol);
        timeout = this.verifyTimeOut(timeout);
        MailServerVerifier verifier = new MailServerVerifier();
        PopMailServerImpl mailServer = new PopMailServerImpl(null, name, description, mailProtocol, hostName, port = this.verifyPortNumber(port, mailProtocol), username, password, timeout.longValue());
        Either result = verifier.verifyMailServer(this.i18nHelper, (MailServer)mailServer, timeout);
        if (result.isLeft()) {
            return Either.left((Object)new SDMailServiceError(((SDMailServerConnectionTestFailure)result.left().get()).getErrorMessage()));
        }
        return Either.right((Object)result.right().get());
    }

    private Either<SDMailServiceError, MailServer> getMailServerById(Long mailServerId) {
        MailServer mailServer;
        try {
            mailServer = this.mailServerManager.getMailServer(mailServerId);
        }
        catch (MailException e) {
            this.log.error("Failed to fetch current mail server", new Object[0]);
            return Either.left((Object)new SDMailServiceError("sd.mail.service.error.read.server"));
        }
        if (mailServer == null) {
            return Either.left((Object)new SDMailServiceError("sd.mail.server.not.found"));
        }
        return Either.right((Object)mailServer);
    }

    private Long verifyTimeOut(Long timeout) {
        if (timeout == null) {
            return 10000L;
        }
        return timeout;
    }

    private MailProtocol getMailProtocol(String protocol) {
        if (StringUtils.isNotBlank((String)protocol)) {
            return MailProtocol.getMailProtocol((String)protocol.trim());
        }
        return MailConstants.DEFAULT_SMTP_PROTOCOL;
    }

    private String verifyPortNumber(String port, MailProtocol mailProtocol) {
        if (StringUtils.isBlank((String)port)) {
            return mailProtocol.getDefaultPort();
        }
        return port;
    }
}

