/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.customfields.participants;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.customfields.service.CustomFieldException;
import com.atlassian.pocketknife.api.customfields.service.CustomFieldMetadata;
import com.atlassian.pocketknife.api.customfields.service.GlobalCustomFieldService;
import com.atlassian.servicedesk.JSDSuccess;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.customfields.participants.ParticipantsCustomFieldManager;
import com.atlassian.servicedesk.internal.feature.reqparticipants.error.RequestParticipantError;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ParticipantsCustomFieldManagerImpl
implements ParticipantsCustomFieldManager {
    private static final Logger log = LoggerFactory.getLogger(ParticipantsCustomFieldManagerImpl.class);
    private final CustomFieldMetadata customFieldMetadata = CustomFieldMetadata.builder().fieldName("sd.request.participants.field.name").fieldDescription("sd.request.participants.desc").fieldType("com.atlassian.servicedesk:sd-request-participants").fieldSearcher("com.atlassian.servicedesk:sd-request-participants-searcher").lockField(true).build();
    private final GlobalCustomFieldService globalCustomFieldService;
    private final RequestParticipantError requestParticipantError;
    private final IssueService issueService;
    private final FieldLayoutManager fieldLayoutManager;
    private final UserFactory userFactory;

    @Autowired
    public ParticipantsCustomFieldManagerImpl(GlobalCustomFieldService globalCustomFieldService, RequestParticipantError requestParticipantError, IssueService issueService, FieldLayoutManager fieldLayoutManager, UserFactory userFactory) {
        this.globalCustomFieldService = globalCustomFieldService;
        this.requestParticipantError = requestParticipantError;
        this.issueService = issueService;
        this.fieldLayoutManager = fieldLayoutManager;
        this.userFactory = userFactory;
    }

    @Override
    public CustomField getParticipantsCustomField() throws CustomFieldException {
        return this.globalCustomFieldService.getGlobalCustomField(this.customFieldMetadata);
    }

    @Override
    public Either<AnError, Set<CheckedUser>> getUserParticipantsFromIssue(Issue issue) {
        CustomField userParticipantCustomField = this.getParticipantsCustomField();
        Option fieldValue = Option.option((Object)userParticipantCustomField.getCustomFieldType()).flatMap(participantsCustomField -> Option.option((Object)participantsCustomField.getValueFromIssue(userParticipantCustomField, issue)));
        if (fieldValue.isEmpty()) {
            return Either.left((Object)this.requestParticipantError.FAILED_TO_RETRIEVE_VALUE_FROM_REQUEST_PARTICIPANT_CUSTOM_FIELD());
        }
        Collection appUsers = (Collection)fieldValue.get();
        return Either.right(this.toCheckedUsers(appUsers));
    }

    @Override
    public Either<AnError, JSDSuccess> updateUserParticipants(CheckedUser user, Issue issue, Set<CheckedUser> participants) {
        Objects.requireNonNull(user);
        Objects.requireNonNull(issue);
        Objects.requireNonNull(participants);
        CustomField userParticipantCustomField = this.getParticipantsCustomField();
        IssueInputParameters issueInputParameters = this.issueService.newIssueInputParameters();
        issueInputParameters.addCustomFieldValue(userParticipantCustomField.getIdAsLong(), (String[])participants.stream().map(CheckedUser::getName).toArray(String[]::new));
        issueInputParameters.setSkipScreenCheck(true);
        Option fieldLayoutItem = Option.option((Object)this.fieldLayoutManager.getFieldLayout(issue)).flatMap(fieldLayout -> Option.option((Object)fieldLayout.getFieldLayoutItem((OrderableField)userParticipantCustomField)));
        if (fieldLayoutItem.isEmpty()) {
            return Either.left((Object)this.requestParticipantError.FAILED_TO_UPDATE_REQUEST_PARTICIPANT_CUSTOM_FIELD_UNKNOWN());
        }
        IssueService.UpdateValidationResult updateValidationResult = this.issueService.validateUpdate(user.forJIRA(), issue.getId(), issueInputParameters);
        if (!updateValidationResult.isValid()) {
            return Either.left((Object)this.requestParticipantError.FAILED_TO_UPDATE_REQUEST_PARTICIPANT_CUSTOM_FIELD(updateValidationResult.getErrorCollection()));
        }
        IssueService.IssueResult issueResult = this.issueService.update(user.forJIRA(), updateValidationResult);
        if (!issueResult.isValid()) {
            return Either.left((Object)this.requestParticipantError.FAILED_TO_UPDATE_REQUEST_PARTICIPANT_CUSTOM_FIELD(issueResult.getErrorCollection()));
        }
        return Either.right((Object)((Object)JSDSuccess.success()));
    }

    @Override
    public boolean participantsHasChanged(Collection<ChangeItemBean> changeItemBeans) {
        CustomField customField = this.getParticipantsCustomField();
        return changeItemBeans.stream().anyMatch(bean -> Objects.equals(customField.getName(), bean.getField()));
    }

    private Set<CheckedUser> toCheckedUsers(Collection<ApplicationUser> users) {
        return ((Collection)Option.option(users).getOr(Collections::emptySet)).stream().flatMap(user -> StreamSupport.stream(this.userFactory.wrap(user).toOption().spliterator(), false)).collect(Collectors.toSet());
    }
}

