/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.customfields.participants;

import com.atlassian.fugue.Either;
import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectImportableCustomField;
import com.atlassian.jira.imports.project.customfield.UserCustomFieldImporter;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.SortableCustomField;
import com.atlassian.jira.issue.customfields.converters.MultiUserConverter;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.AbstractMultiCFType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.impl.rest.MultiUserCustomFieldOperationsHandler;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.UserField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareCustomFieldType;
import com.atlassian.jira.issue.fields.rest.RestCustomFieldTypeOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.UserBeanFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.issue.index.indexers.FieldIndexer;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.notification.type.UserCFNotificationTypeAware;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.pocketknife.annotations.lucene.LuceneUsage;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.customfields.CustomFieldIssueHelper;
import com.atlassian.servicedesk.internal.customfields.MultiCFTypeEqualityUtil;
import com.atlassian.servicedesk.internal.feature.reqparticipants.validation.RequestParticipantValidator;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import com.atlassian.servicedesk.internal.rest.ServiceDeskJaxbJsonMashaller;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LuceneUsage(type=LuceneUsage.LuceneUsageType.Indexer)
public class ParticipantsCFType
extends AbstractMultiCFType<ApplicationUser>
implements UserCFNotificationTypeAware,
ProjectImportableCustomField,
UserField,
SortableCustomField<String>,
RestAwareCustomFieldType,
RestCustomFieldTypeOperations {
    private static final Logger log = LoggerFactory.getLogger(ParticipantsCFType.class);
    private final MultiUserConverter multiUserConverter;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final JiraBaseUrls jiraBaseUrls;
    private final UserBeanFactory userBeanFactory;
    private final ServiceDeskInternalManager serviceDeskManager;
    private final UserManager userManager;
    private final RequestParticipantValidator requestParticipantValidator;
    private final UserFactory userFactory;
    private final JiraAuthenticationContext authCtx;
    private final UserCustomFieldImporter userCustomFieldImporter;
    private final CustomFieldIssueHelper customFieldIssueHelper;

    public ParticipantsCFType(CustomFieldValuePersister customFieldValuePersister, GenericConfigManager genericConfigManager, MultiUserConverter multiUserConverter, FieldVisibilityManager fieldVisibilityManager, JiraBaseUrls jiraBaseUrls, UserBeanFactory userBeanFactory, ServiceDeskInternalManager serviceDeskManager, UserManager userManager, RequestParticipantValidator requestParticipantValidator, UserFactory userFactory, JiraAuthenticationContext authCtx, CustomFieldIssueHelper customFieldIssueHelper) {
        super(customFieldValuePersister, genericConfigManager);
        this.multiUserConverter = multiUserConverter;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.jiraBaseUrls = jiraBaseUrls;
        this.userBeanFactory = userBeanFactory;
        this.serviceDeskManager = serviceDeskManager;
        this.userManager = userManager;
        this.requestParticipantValidator = requestParticipantValidator;
        this.userFactory = userFactory;
        this.authCtx = authCtx;
        this.customFieldIssueHelper = customFieldIssueHelper;
        this.userCustomFieldImporter = new UserCustomFieldImporter();
    }

    protected Comparator<ApplicationUser> getTypeComparator() {
        return null;
    }

    public void updateValue(CustomField customField, Issue issue, Collection<ApplicationUser> value) {
        super.updateValue(customField, issue, value);
    }

    public String getChangelogValue(CustomField field, Collection<ApplicationUser> values2) {
        ArrayList<String> applicationUserKeys = new ArrayList<String>();
        if (values2 == null) {
            return "";
        }
        for (ApplicationUser applicationUser : values2) {
            applicationUserKeys.add(applicationUser.getKey());
        }
        return StringUtils.join(applicationUserKeys, (String)", ");
    }

    public String getChangelogString(CustomField field, Collection<ApplicationUser> value) {
        String glue = ", ";
        if (value == null) {
            return "";
        }
        StringBuilder changelogStringEntry = new StringBuilder();
        Iterator<ApplicationUser> usersIterator = value.iterator();
        while (usersIterator.hasNext()) {
            ApplicationUser nextUser = usersIterator.next();
            if (nextUser == null) continue;
            changelogStringEntry.append(nextUser.getDisplayName());
            if (!usersIterator.hasNext()) continue;
            changelogStringEntry.append(", ");
        }
        return changelogStringEntry.toString();
    }

    public Collection<ApplicationUser> getValueFromIssue(CustomField field, Issue issue) {
        if (this.isFieldEnabled(issue)) {
            return this.getUsersFromIssue(field, issue);
        }
        return null;
    }

    private Collection<ApplicationUser> getUsersFromIssue(CustomField field, Issue issue) {
        List<Object> textValues = this.customFieldValuePersister.getValues(field, issue.getId(), this.getDatabaseType()).stream().distinct().collect(Collectors.toList());
        return textValues == null || textValues.isEmpty() ? Collections.emptyList() : this.convertDbObjectToTypesUnsorted(textValues);
    }

    private Collection<ApplicationUser> convertDbObjectToTypesUnsorted(Collection<Object> dbObjects) {
        if (dbObjects == null) {
            return null;
        }
        ArrayList<ApplicationUser> result = new ArrayList<ApplicationUser>();
        for (Object element : dbObjects) {
            try {
                ApplicationUser appUser = this.convertDbValueToType(element);
                if (appUser == null || !appUser.isActive()) continue;
                result.add(appUser);
            }
            catch (FieldValidationException exception) {
                log.info("Failed to convert user object value '" + element + "' into ApplicationUser", (Throwable)exception);
            }
        }
        return result;
    }

    public Collection<ApplicationUser> getValueFromCustomFieldParams(CustomFieldParams parameters) throws FieldValidationException {
        HashSet<ApplicationUser> result = new HashSet<ApplicationUser>();
        Collection values2 = parameters.getValuesForNullKey();
        if (values2 == null || values2.isEmpty()) {
            return null;
        }
        for (Object value : values2) {
            result.addAll(this.convertPresentationStringsToUsers(new ArrayList<String>(this.multiUserConverter.extractUserStringsFromString((String)value))));
        }
        return result;
    }

    private Collection<ApplicationUser> convertPresentationStringsToUsers(List<String> presentationStrings) {
        if (presentationStrings == null) {
            return null;
        }
        HashSet<ApplicationUser> result = new HashSet<ApplicationUser>();
        for (String presentationString : presentationStrings) {
            try {
                ApplicationUser appUser = this.multiUserConverter.getUserFromHttpParameterWithValidation(presentationString);
                if (appUser == null || !appUser.isActive()) continue;
                result.add(appUser);
            }
            catch (FieldValidationException e) {
                log.warn("Failed to convert username presentation string '" + presentationString + "' into ApplicationUser", (Throwable)e);
            }
        }
        return result;
    }

    public Object getStringValueFromCustomFieldParams(CustomFieldParams parameters) {
        Collection users = parameters.getValuesForNullKey();
        if (users == null || users.isEmpty()) {
            return null;
        }
        ArrayList applicationUsers = Lists.newArrayList();
        for (Object user : users) {
            String userName = (String)user;
            try {
                ApplicationUser appUser = this.userManager.getUserByName(userName);
                if (appUser == null || !appUser.isActive()) continue;
                applicationUsers.add(appUser);
            }
            catch (IllegalStateException e) {
                log.info("Failed to convert username '" + userName + "' into ApplicationUser", (Throwable)e);
            }
        }
        return this.mapUsersToJsonable(applicationUsers);
    }

    public void validateFromParams(CustomFieldParams relevantParams, ErrorCollection errorCollectionToAddTo, FieldConfig config) {
        Option<Issue> issue;
        ArrayList<CheckedUser> checkedUsers = new ArrayList<CheckedUser>();
        ArrayList<String> missingUsernames = new ArrayList<String>();
        for (Object o : relevantParams.getValuesForNullKey()) {
            String singleParam = (String)o;
            Collection userStrings = this.multiUserConverter.extractUserStringsFromString(singleParam);
            if (userStrings == null) {
                return;
            }
            for (String userName : userStrings) {
                if (!StringUtils.isNotBlank((String)userName)) continue;
                try {
                    ApplicationUser user = this.multiUserConverter.getUserFromHttpParameterWithValidation(userName);
                    io.atlassian.fugue.Either checkedUser = StepsConverters.newerEither((Either)this.userFactory.wrap(user));
                    if (checkedUser.isRight()) {
                        checkedUsers.add((CheckedUser)checkedUser.right().get());
                        continue;
                    }
                    missingUsernames.add(userName);
                }
                catch (FieldValidationException e) {
                    missingUsernames.add(userName);
                }
            }
        }
        ArrayList<String> errorMessages2 = new ArrayList<String>();
        if (!missingUsernames.isEmpty()) {
            errorMessages2.add(this.getI18nBean().getText("sd.request.participants.validation.missing.usernames", StringUtils.join(missingUsernames, (String)", ")));
        }
        if ((issue = this.customFieldIssueHelper.getIssueFromCustomFieldParams(relevantParams)).isDefined()) {
            Collection<CheckedUser> storedValues = this.getStoredValues(relevantParams);
            for (String errorMsg : this.requestParticipantValidator.getParticipantsValidationErrorMessage(checkedUsers, storedValues, (Issue)issue.get())) {
                errorMessages2.add(errorMsg);
            }
        }
        if (!errorMessages2.isEmpty()) {
            errorCollectionToAddTo.addError(config.getCustomField().getId(), StringUtils.join(errorMessages2, (String)"; "), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    private Collection<CheckedUser> getStoredValues(CustomFieldParams relevantParams) {
        Option<Issue> issue = this.customFieldIssueHelper.getIssueFromCustomFieldParams(relevantParams);
        if (issue.isEmpty()) {
            return Collections.emptySet();
        }
        Collection applicationUsers = (Collection)((Issue)issue.get()).getCustomFieldValue(relevantParams.getCustomField());
        return ((Collection)Option.option((Object)applicationUsers).getOr(Collections::emptySet)).stream().flatMap(user -> StreamSupport.stream(this.userFactory.wrap(user).toOption().spliterator(), false)).collect(Collectors.toList());
    }

    public String getStringFromSingularObject(ApplicationUser o) {
        return this.multiUserConverter.getHttpParameterValue(o);
    }

    public ApplicationUser getSingularObjectFromString(String s) throws FieldValidationException {
        return this.multiUserConverter.getUserFromHttpParameterWithValidation(s);
    }

    @Nonnull
    protected PersistenceFieldType getDatabaseType() {
        return PersistenceFieldType.TYPE_LIMITED_TEXT;
    }

    public List<FieldIndexer> getRelatedIndexers(CustomField customField) {
        return Lists.newArrayList((Object[])new FieldIndexer[]{new MultiUserCustomFieldIndexer(this.fieldVisibilityManager, customField, this.multiUserConverter)});
    }

    protected Object convertTypeToDbValue(ApplicationUser value) {
        return this.multiUserConverter.getDbString(value);
    }

    protected ApplicationUser convertDbValueToType(Object string) {
        return this.multiUserConverter.getUserFromDbString((String)string);
    }

    @Nonnull
    public Map<String, Object> getVelocityParameters(Issue issue, CustomField field, FieldLayoutItem fieldLayoutItem) {
        if (issue != null) {
            Map velocityParams = super.getVelocityParameters(issue, field, fieldLayoutItem);
            List<UserJsonBean> userJsonBeans = this.mapUsersToJsonable((Collection<ApplicationUser>)this.getValueFromIssue(field, issue));
            String usersJsonString = new ServiceDeskJaxbJsonMashaller().marshal(userJsonBeans);
            velocityParams.put("isFieldEnabled", this.isFieldEnabled(issue));
            velocityParams.put("issueKey", issue.getKey());
            velocityParams.put("usersJson", usersJsonString);
            return velocityParams;
        }
        return Collections.emptyMap();
    }

    private boolean isFieldEnabled(Issue issue) {
        if (issue != null && issue.isCreated()) {
            return this.serviceDeskManager.isServiceDeskEnabled(issue.getProjectObject());
        }
        return false;
    }

    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        return "sd.request.participants.bulk.edit.unsupported";
    }

    public ProjectCustomFieldImporter getProjectImporter() {
        return this.userCustomFieldImporter;
    }

    public int compare(@Nonnull String customFieldObjectValue1, @Nonnull String customFieldObjectValue2, FieldConfig fieldConfig) {
        return customFieldObjectValue1.compareTo(customFieldObjectValue2);
    }

    public Object accept(AbstractCustomFieldType.VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visitMultiUser(this);
        }
        return super.accept(visitor);
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        return (FieldTypeInfo)Option.option((Object)fieldTypeInfoContext.getIssue()).flatMap(issue -> Option.option((Object)issue.getKey())).fold(() -> new FieldTypeInfo(null, null), issueKey -> {
            String userPickerAutoCompleteUrl = String.format("%s/rest/servicedesk/1/servicedesk/sd-user-search/participants?issueKey=%s&query=", this.jiraBaseUrls.baseUrl(), issueKey);
            return new FieldTypeInfo(null, userPickerAutoCompleteUrl);
        });
    }

    public JsonType getJsonSchema(CustomField customField) {
        return JsonTypeBuilder.customArray((String)"user", (String)this.getKey(), (Long)customField.getIdAsLong());
    }

    public FieldJsonRepresentation getJsonFromIssue(CustomField field, Issue issue, boolean renderedVersionRequested, @Nullable FieldLayoutItem fieldLayoutItem) {
        List<UserJsonBean> usersAsJson = this.mapUsersToJsonable((Collection<ApplicationUser>)this.getValueFromIssue(field, issue));
        return new FieldJsonRepresentation(new JsonData(usersAsJson));
    }

    public RestFieldOperationsHandler getRestFieldOperation(CustomField field) {
        return new MultiUserCustomFieldOperationsHandler(field, this.getI18nBean());
    }

    public JsonData getJsonDefaultValue(IssueContext issueCtx, CustomField field) {
        FieldConfig config = field.getRelevantConfig(issueCtx);
        List<UserJsonBean> usersAsJson = this.mapUsersToJsonable(this.getDefaultValue(config));
        return new JsonData(usersAsJson);
    }

    public boolean valuesEqual(Collection<ApplicationUser> existingRP, Collection<ApplicationUser> newRP) {
        return MultiCFTypeEqualityUtil.valuesEqual(existingRP, newRP);
    }

    private List<UserJsonBean> mapUsersToJsonable(Collection<ApplicationUser> users) {
        if (users != null) {
            ApplicationUser executingUser = this.authCtx.getLoggedInUser();
            ArrayList<UserJsonBean> result = new ArrayList<UserJsonBean>();
            for (ApplicationUser user : users) {
                UserJsonBean bean = this.userBeanFactory.createBean(user, executingUser);
                bean.setKey(user.getKey());
                result.add(bean);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static interface Visitor<T>
    extends AbstractCustomFieldType.VisitorBase<T> {
        public T visitMultiUser(ParticipantsCFType var1);
    }

    static class MultiUserCustomFieldIndexer
    extends AbstractCustomFieldIndexer {
        private final CustomField customField;
        private final MultiUserConverter multiUserConverter;

        public MultiUserCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField, MultiUserConverter multiUserConverter) {
            super(fieldVisibilityManager, customField);
            this.customField = customField;
            this.multiUserConverter = multiUserConverter;
        }

        public void addDocumentFieldsSearchable(Document doc, Issue issue) {
            this.addDocumentFields(doc, issue, Field.Index.NOT_ANALYZED_NO_NORMS);
        }

        public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
            this.addDocumentFields(doc, issue, Field.Index.NO);
        }

        public void addDocumentFields(Document doc, Issue issue, Field.Index indexType) {
            Collection o = (Collection)this.customField.getValue(issue);
            if (o != null) {
                for (Object anO : o) {
                    ApplicationUser user = (ApplicationUser)anO;
                    String userId = this.multiUserConverter.getDbString(user);
                    doc.add((Fieldable)new Field(this.getDocumentFieldId(), userId, Field.Store.YES, indexType));
                }
            }
        }
    }
}

