/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.customfields.origin;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.pocketknife.annotations.lucene.LuceneUsage;
import com.atlassian.servicedesk.bootstrap.lifecycle.ServiceDeskComponentAccessor;
import com.atlassian.servicedesk.internal.customfields.origin.VpOrigin;
import com.atlassian.servicedesk.internal.customfields.origin.VpOriginManager;
import com.atlassian.servicedesk.internal.util.SafeRunner;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

@LuceneUsage(type=LuceneUsage.LuceneUsageType.Indexer)
public class VpOriginCustomFieldIndexer
extends AbstractCustomFieldIndexer {
    protected VpOriginCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField) {
        super(fieldVisibilityManager, customField);
    }

    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        this.getSafeRunner().run(() -> this.addDocumentFields(doc, issue));
    }

    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        this.getSafeRunner().run(() -> this.addDocumentFields(doc, issue));
    }

    private void addDocumentFields(Document doc, Issue issue) {
        VpOrigin origin = this.vpOriginManager().lookup(issue);
        if (origin != null) {
            doc.add((Fieldable)new Field(this.getDocumentFieldId(), origin.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
    }

    private VpOriginManager vpOriginManager() {
        return ServiceDeskComponentAccessor.vpOriginManager();
    }

    private SafeRunner getSafeRunner() {
        return ServiceDeskComponentAccessor.getSafeRunner();
    }
}

