/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.customfields.origin;

import com.atlassian.fugue.Option;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternalService;
import com.atlassian.servicedesk.internal.customfields.origin.VpOrigin;
import com.atlassian.servicedesk.internal.customfields.origin.VpOriginManager;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.util.ProjectContextHelper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Either;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class VpOriginClauseValueGenerator
implements ClauseValuesGenerator {
    private final UserFactory userFactory;
    private final RequestTypeInternalService requestTypeService;
    private final InternalPortalService portalService;
    private final ProjectContextHelper projectContextHelper;
    private final VpOriginManager vpOriginManager;
    private final InternalServiceDeskProjectManager internalServiceDeskProjectManager;

    public VpOriginClauseValueGenerator(UserFactory userFactory, InternalPortalService portalService, RequestTypeInternalService requestTypeService, ProjectContextHelper projectContextHelper, VpOriginManager vpOriginManager, InternalServiceDeskProjectManager internalServiceDeskProjectManager) {
        this.userFactory = userFactory;
        this.portalService = portalService;
        this.requestTypeService = requestTypeService;
        this.projectContextHelper = projectContextHelper;
        this.vpOriginManager = vpOriginManager;
        this.internalServiceDeskProjectManager = internalServiceDeskProjectManager;
    }

    public ClauseValuesGenerator.Results getPossibleValues(ApplicationUser applicationUser, String jqlClauseName, String valuePrefix, int maxNumResults) {
        List results = (List)Steps.begin((Option)this.userFactory.wrap(applicationUser).toOption()).yield(checkedUser -> this.buildRequestTypeSuggestions((CheckedUser)checkedUser, valuePrefix, maxNumResults)).getOrElse(Collections.emptyList());
        return new ClauseValuesGenerator.Results(results);
    }

    private ClauseValuesGenerator.Result getResultFromRequestType(Map<Integer, Portal> portalIdValueMap, Map<Portal, Project> portalToProjectMap, RequestType requestType) {
        Either projectEither;
        Portal portal = portalIdValueMap.get((int)requestType.getPortalId());
        Project project = portalToProjectMap.get(portal);
        if (project == null && (projectEither = this.internalServiceDeskProjectManager.getProject(Long.valueOf(this.portalService.getProjectIdForPortal(portal)))).isRight()) {
            project = (Project)projectEither.right().get();
            portalToProjectMap.put(portal, project);
        }
        if (project == null) {
            VpOrigin vpOrigin = this.vpOriginManager.getVpOriginForRequestType(portal, requestType);
            return new ClauseValuesGenerator.Result(vpOrigin.toString(), requestType.getName() + " (" + portal.getName() + ")");
        }
        return new ClauseValuesGenerator.Result(requestType.getName() + " (" + project.getKey() + ")", requestType.getName() + " (" + portal.getName() + ")");
    }

    private List<ClauseValuesGenerator.Result> buildRequestTypeSuggestions(CheckedUser checkedUser, String valuePrefix, int maxNumResults) {
        List<Portal> portals = this.getPortals(checkedUser);
        ImmutableMap portalIdValueMap = Maps.uniqueIndex(portals, Portal::getId);
        HashMap portalToProjectMap = new HashMap();
        List requestTypes = this.requestTypeService.searchRequestTypes(portalIdValueMap.keySet(), checkedUser, valuePrefix, maxNumResults);
        Supplier<TreeSet> treeSetUniqueResultNameSupplier = () -> new TreeSet<ClauseValuesGenerator.Result>(new ResultNameComparator());
        return requestTypes.stream().map(arg_0 -> this.lambda$buildRequestTypeSuggestions$2((Map)portalIdValueMap, portalToProjectMap, arg_0)).collect(Collectors.toCollection(treeSetUniqueResultNameSupplier)).stream().collect(Collectors.toList());
    }

    private List<Portal> getPortals(CheckedUser checkedUser) {
        io.atlassian.fugue.Option portalOpt = Steps.begin(this.projectContextHelper.getProjectFromEditQueueContext()).then(project -> this.portalService.getPortalByProject(checkedUser, (Project)project).toOption()).yield((project, portal) -> portal);
        return (List)portalOpt.fold(() -> this.portalService.getPortals(checkedUser), Collections::singletonList);
    }

    private /* synthetic */ ClauseValuesGenerator.Result lambda$buildRequestTypeSuggestions$2(Map portalIdValueMap, Map portalToProjectMap, RequestType requestType) {
        return this.getResultFromRequestType(portalIdValueMap, portalToProjectMap, requestType);
    }

    public class ResultNameComparator
    implements Comparator<ClauseValuesGenerator.Result> {
        @Override
        public int compare(ClauseValuesGenerator.Result o1, ClauseValuesGenerator.Result o2) {
            return o1.getDisplayNameParts()[0].toLowerCase().compareTo(o2.getDisplayNameParts()[0].toLowerCase());
        }
    }
}

