/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.customfields.origin;

import com.atlassian.fugue.Option;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.SupportedOperatorsValidator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.SingleValueOperand;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.customfields.util.VpOriginResolver;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class VpOriginClauseValidator
implements ClauseValidator {
    private final SupportedOperatorsValidator supportedOperatorsValidator;
    private final JqlOperandResolver operandResolver;
    private final UserFactory userFactory;
    private final I18nHelper i18nHelper;
    private final InternalPortalService internalPortalService;
    private final VpOriginResolver vpOriginResolver;

    public VpOriginClauseValidator(JqlOperandResolver operandResolver, UserFactory userFactory, I18nHelper i18nHelper, InternalPortalService internalPortalService, VpOriginResolver vpOriginResolver) {
        this.internalPortalService = internalPortalService;
        this.supportedOperatorsValidator = new SupportedOperatorsValidator(new Collection[]{OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY, OperatorClasses.RELATIONAL_ONLY_OPERATORS});
        this.operandResolver = operandResolver;
        this.userFactory = userFactory;
        this.i18nHelper = i18nHelper;
        this.vpOriginResolver = vpOriginResolver;
    }

    public MessageSet validate(ApplicationUser searcher, TerminalClause terminalClause) {
        MessageSet messageSet = this.supportedOperatorsValidator.validate(searcher, terminalClause);
        io.atlassian.fugue.Option<List<QueryLiteral>> queries = this.getRawValues(searcher, terminalClause);
        for (QueryLiteral query : (List)queries.getOrElse((Object)Lists.newArrayList())) {
            if (this.isEmptyLiteral(query)) continue;
            this.getLoggingSearcher(searcher).flatMap(checkedUser -> this.getPortals((CheckedUser)checkedUser, messageSet)).flatMap(portals -> this.getValidRequestTypesFromRawValues(query, (List<Portal>)portals)).forEach(requestTypes -> {
                if (requestTypes.isEmpty()) {
                    messageSet.addErrorMessage(this.i18nHelper.getText("sd.request.type.search.no.matched.request.type.name", query.getStringValue()));
                }
            });
        }
        return messageSet;
    }

    private boolean isEmptyLiteral(QueryLiteral queryLiteral) {
        return null == queryLiteral.getStringValue();
    }

    private io.atlassian.fugue.Option<List<QueryLiteral>> getRawValues(ApplicationUser searcher, TerminalClause terminalClause) {
        List<QueryLiteral> rawValues;
        Operand operand = terminalClause.getOperand();
        if ((this.operandResolver.isListOperand(operand) || this.isSingleValueOperand(operand)) && !this.isEmpty(rawValues = this.getValues(searcher, terminalClause))) {
            return io.atlassian.fugue.Option.option(rawValues);
        }
        return io.atlassian.fugue.Option.none();
    }

    private io.atlassian.fugue.Option<CheckedUser> getLoggingSearcher(ApplicationUser applicationUser) {
        return Steps.begin((io.atlassian.fugue.Option)io.atlassian.fugue.Option.option((Object)applicationUser)).then(user -> StepsConverters.newerOption((Option)this.userFactory.wrap(user).toOption())).yield((user, checkedUser) -> checkedUser);
    }

    private io.atlassian.fugue.Option<List<Portal>> getPortals(CheckedUser checkedUser, MessageSet messageSet) {
        List<Portal> portals = this.internalPortalService.getCustomerVisiblePortals(checkedUser);
        if (portals.isEmpty()) {
            messageSet.addErrorMessage(this.i18nHelper.getText("sd.request.type.search.no.portal"));
            return io.atlassian.fugue.Option.none();
        }
        return io.atlassian.fugue.Option.option(portals);
    }

    private io.atlassian.fugue.Option<List<RequestType>> getValidRequestTypesFromRawValues(QueryLiteral rawValue, List<Portal> portals) {
        List<RequestType> requestTypes = this.vpOriginResolver.resolveValidRequestTypes(Collections.singletonList(rawValue), portals);
        return io.atlassian.fugue.Option.some(requestTypes);
    }

    private boolean isSingleValueOperand(Operand operand) {
        return operand instanceof SingleValueOperand;
    }

    private boolean isEmpty(List<QueryLiteral> rawValues) {
        return rawValues == null || rawValues.size() == 0 || rawValues.size() == 1 && rawValues.get(0) == null;
    }

    private List<QueryLiteral> getValues(ApplicationUser searcher, TerminalClause clause) {
        return this.operandResolver.getValues(searcher, clause.getOperand(), clause);
    }
}

