/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.customfields.origin;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypeImpl;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.impl.AbstractSingleFieldType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareCustomFieldType;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.request.CustomerRequest;
import com.atlassian.servicedesk.api.request.CustomerRequestQuery;
import com.atlassian.servicedesk.api.request.ServiceDeskCustomerRequestService;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternalService;
import com.atlassian.servicedesk.internal.api.util.SoyTemplateRenderer;
import com.atlassian.servicedesk.internal.customfields.SDCustomfieldBulkEditSecurityHelper;
import com.atlassian.servicedesk.internal.customfields.origin.VpOrigin;
import com.atlassian.servicedesk.internal.customfields.origin.VpOriginManager;
import com.atlassian.servicedesk.internal.customfields.util.FieldJsonBuilderAccessor;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeInternalServiceImpl;
import com.atlassian.servicedesk.internal.spi.jira.field.json.FieldJsonBuilderService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class VpOriginCFType
extends AbstractSingleFieldType<VpOrigin>
implements RestAwareCustomFieldType {
    public static final JiraDataType ORIGIN = new JiraDataTypeImpl(VpOrigin.class);
    private static final String JSON_SCHEMA_TYPE = "sd-customerrequesttype";
    private static final String VIEW_TEMPLATE = "viewTemplate";
    private static final String MODULE = "module";
    private static final String SOY_RENDERER = "soyRenderer";
    private final VpOriginManager vpOriginManager;
    private final RequestTypeInternalServiceImpl requestTypeInternalServiceImpl;
    private final RequestTypeInternalService requestTypeInternalService;
    private final UserFactory userFactory;
    private final I18nHelper i18nHelper;
    private final ErrorResultHelper errorResultHelper;
    private final ServiceDeskCustomerRequestService customerRequestService;
    private final FieldJsonBuilderAccessor fieldJsonBuilderAccessor;
    private final InternalPortalService internalPortalService;
    private final InternalServiceDeskProjectManager internalServiceDeskProjectManager;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final SDCustomfieldBulkEditSecurityHelper securityHelper;

    public VpOriginCFType(CustomFieldValuePersister customFieldValuePersister, GenericConfigManager genericConfigManager, VpOriginManager vpOriginManager, RequestTypeInternalServiceImpl requestTypeInternalServiceImpl, RequestTypeInternalService requestTypeInternalService, UserFactory userFactory, I18nHelper i18nHelper, ErrorResultHelper errorResultHelper, ServiceDeskCustomerRequestService customerRequestService, FieldJsonBuilderAccessor fieldJsonBuilderAccessor, InternalPortalService internalPortalService, InternalServiceDeskProjectManager internalServiceDeskProjectManager, SoyTemplateRenderer soyTemplateRenderer, SDCustomfieldBulkEditSecurityHelper securityHelper) {
        super(customFieldValuePersister, genericConfigManager);
        this.vpOriginManager = vpOriginManager;
        this.requestTypeInternalServiceImpl = requestTypeInternalServiceImpl;
        this.requestTypeInternalService = requestTypeInternalService;
        this.userFactory = userFactory;
        this.i18nHelper = i18nHelper;
        this.errorResultHelper = errorResultHelper;
        this.customerRequestService = customerRequestService;
        this.fieldJsonBuilderAccessor = fieldJsonBuilderAccessor;
        this.internalPortalService = internalPortalService;
        this.internalServiceDeskProjectManager = internalServiceDeskProjectManager;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.securityHelper = securityHelper;
    }

    public VpOrigin getSingularObjectFromString(String string) throws FieldValidationException {
        return this.vpOriginManager.fromDbFormatUnchecked(string);
    }

    public String getStringFromSingularObject(VpOrigin origin) {
        if (origin == null) {
            return null;
        }
        return this.vpOriginManager.toDbFormat(origin);
    }

    public void validateFromParams(CustomFieldParams relevantParams, ErrorCollection errorCollectionToAddTo, FieldConfig config) {
        Collection values2 = relevantParams.getValuesForNullKey();
        if (values2 == null) {
            return;
        }
        for (String value : values2) {
            VpOrigin lookup = this.vpOriginManager.fromDbFormat(value);
            if (lookup != null) continue;
            errorCollectionToAddTo.addError(config.getFieldId(), this.i18nHelper.getText("sd.origin.customfield.invalid.cf.value", value), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    protected Object getDbValueFromObject(VpOrigin origin) {
        return origin == null ? null : this.vpOriginManager.toDbFormat(origin);
    }

    protected VpOrigin getObjectFromDbValue(@Nonnull Object databaseValue) throws FieldValidationException {
        return this.getSingularObjectFromString(databaseValue.toString());
    }

    public RequestType getDisplayedValue(String value) {
        try {
            VpOrigin origin = this.getSingularObjectFromString(value);
            return this.getDisplayedValue(origin);
        }
        catch (FieldValidationException fve) {
            return null;
        }
    }

    public RequestType getDisplayedValue(VpOrigin value) {
        if (value == null) {
            return null;
        }
        io.atlassian.fugue.Option optUser = StepsConverters.newerOption((Option)this.userFactory.getCheckedUser().toOption());
        if (optUser.isEmpty()) {
            return null;
        }
        io.atlassian.fugue.Option optPortal = this.internalPortalService.getPortal((CheckedUser)optUser.get(), value.getPortalKey()).toOption();
        if (optPortal.isEmpty()) {
            return null;
        }
        io.atlassian.fugue.Option optProject = this.internalServiceDeskProjectManager.getProject(Long.valueOf(this.internalPortalService.toPortalInternal((Portal)optPortal.get()).getProjectId())).toOption();
        if (optProject.isEmpty()) {
            return null;
        }
        io.atlassian.fugue.Option optRequestType = this.requestTypeInternalService.getRequestTypeByKey((CheckedUser)optUser.get(), value.getRequestTypeKey(), (Project)optProject.get(), (Portal)optPortal.get()).toOption();
        return (RequestType)optRequestType.getOrNull();
    }

    @Nonnull
    public Map<String, Object> getVelocityParameters(Issue issue, CustomField field, FieldLayoutItem fieldLayoutItem) {
        MapBuilder mapBuilder = MapBuilder.newBuilder();
        if (issue != null) {
            VpOrigin origin = (VpOrigin)field.getValue(issue);
            mapBuilder.add((Object)"origin", (Object)origin);
            io.atlassian.fugue.Option requestType = StepsConverters.newerOption((Option)this.userFactory.getCheckedUser().toOption()).flatMap(user -> this.getRequestType((CheckedUser)user, origin, issue));
            requestType.foreach(input -> mapBuilder.add((Object)"requestType", input));
        }
        mapBuilder.add((Object)MODULE, (Object)"com.atlassian.servicedesk:soy");
        mapBuilder.add((Object)VIEW_TEMPLATE, (Object)"ServiceDesk.Templates.CustomFields.CustomerRequestType.view");
        mapBuilder.add((Object)SOY_RENDERER, (Object)this.soyTemplateRenderer);
        return mapBuilder.toMap();
    }

    private io.atlassian.fugue.Option<RequestType> getRequestType(CheckedUser user, VpOrigin origin, Issue issue) {
        return io.atlassian.fugue.Option.option((Object)origin).flatMap(input -> this.requestTypeInternalServiceImpl.getRequestTypeForIssueWithVpOrigin(user, issue, (VpOrigin)input).toOption());
    }

    public boolean isRenderable() {
        return true;
    }

    @Nonnull
    protected PersistenceFieldType getDatabaseType() {
        return PersistenceFieldType.TYPE_LIMITED_TEXT;
    }

    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        if (bulkEditBean.isMultipleProjects()) {
            return "bulk.edit.unavailable.multipleprojects";
        }
        if (bulkEditBean.isMutipleIssueTypes()) {
            return "bulk.edit.unavailable.multipleissuetypes";
        }
        Project project = bulkEditBean.getSingleProject();
        IssueType issueType = (IssueType)bulkEditBean.getIssueTypeObjects().iterator().next();
        io.atlassian.fugue.Option optUser = StepsConverters.newerOption((Option)this.userFactory.getCheckedUser().toOption());
        io.atlassian.fugue.Option portal = this.internalPortalService.getPortalByProject((CheckedUser)optUser.get(), project).toOption();
        io.atlassian.fugue.Option<String> allowedForSDBulkEdit = this.securityHelper.isAllowedForSDBulkEdit(bulkEditBean);
        if (allowedForSDBulkEdit.isDefined()) {
            return (String)allowedForSDBulkEdit.get();
        }
        List requestTypesByIssueType = this.requestTypeInternalService.getRequestTypesByIssueType((CheckedUser)optUser.get(), project, (Portal)portal.get(), issueType);
        if (requestTypesByIssueType.isEmpty()) {
            return "bulk.edit.unavailable.requesttypenotavailable";
        }
        return null;
    }

    public boolean valuesEqual(VpOrigin existingValue, VpOrigin newValue) {
        return existingValue.equals(newValue);
    }

    public String getChangelogValue(CustomField field, VpOrigin value) {
        RequestType displayedValue = this.getDisplayedValue(value);
        if (displayedValue == null) {
            return "";
        }
        return displayedValue.getName();
    }

    public JsonType getJsonSchema(CustomField customField) {
        return JsonTypeBuilder.custom((String)JSON_SCHEMA_TYPE, (String)this.getKey(), (Long)customField.getIdAsLong());
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        return new FieldTypeInfo(null, null);
    }

    public FieldJsonRepresentation getJsonFromIssue(CustomField field, Issue issue, boolean renderedVersionRequested, FieldLayoutItem fieldLayoutItem) {
        io.atlassian.fugue.Option rawValue = io.atlassian.fugue.Option.option((Object)field.getValue(issue));
        if (rawValue.isEmpty()) {
            return this.fieldJsonBuilderAccessor.build(FieldJsonBuilderService::buildNullJson);
        }
        ApplicationUser user = this.userFactory.getUncheckedUser().forJIRA();
        return this.fieldJsonBuilderAccessor.build(this.buildJson(issue, user));
    }

    private Function<FieldJsonBuilderService, FieldJsonRepresentation> buildJson(Issue issue, ApplicationUser user) {
        return jsonService -> {
            io.atlassian.fugue.Either<AnError, CustomerRequest> result = this.getCustomerRequest(issue, user);
            return (FieldJsonRepresentation)result.fold(arg_0 -> ((FieldJsonBuilderService)jsonService).buildErrorJson(arg_0), customerRequest -> jsonService.buildCustomerRequestJson(user, customerRequest));
        };
    }

    private io.atlassian.fugue.Either<AnError, CustomerRequest> getCustomerRequest(Issue issue, ApplicationUser user) {
        CustomerRequestQuery query = this.customerRequestService.newQueryBuilder().issue(issue.getId()).build();
        io.atlassian.fugue.Either pagedResponse = StepsConverters.newerEither((Either)this.customerRequestService.getCustomerRequests(user, query));
        return pagedResponse.flatMap(pr -> io.atlassian.fugue.Option.fromOptional((Optional)pr.findFirst()).toRight(this::entityNotFound));
    }

    private AnError entityNotFound() {
        return this.errorResultHelper.notFound404("sd.entity.not.found", new Object[0]).build();
    }
}

