/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.customfields.organization;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.DefaultCustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.searchers.AbstractInitializationCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.searchers.CustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.SimpleCustomFieldContextValueGeneratingClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.information.CustomFieldSearcherInformation;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.SimpleClauseContextFactory;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.SupportedOperatorsValidator;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.pocketknife.internal.customfields.query.JSDActualValueCustomFieldClauseQueryFactory;
import com.atlassian.query.operator.Operator;
import com.atlassian.servicedesk.internal.api.license.ServiceDeskOperationalStatus;
import com.atlassian.servicedesk.internal.customfields.DummySearchRenderer;
import com.atlassian.servicedesk.internal.customfields.organization.CustomerOrganizationClauseValuesGenerator;
import com.atlassian.servicedesk.internal.customfields.organization.CustomerOrganizationsCFType;
import com.atlassian.servicedesk.internal.customfields.organization.CustomerOrganizationsClauseValidator;
import com.atlassian.servicedesk.internal.customfields.organization.CustomerOrganizationsIndexValuesConverter;
import com.atlassian.servicedesk.internal.customfields.organization.CustomerOrganizationsIndexer;
import com.atlassian.servicedesk.internal.customfields.organization.CustomerOrganizationsSearchInputTransformer;
import com.atlassian.servicedesk.internal.feature.organization.CustomerOrganizationManager;
import com.atlassian.servicedesk.internal.user.license.ServiceDeskUserLicenseService;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class CustomerOrganizationsSearcher
extends AbstractInitializationCustomFieldSearcher
implements CustomFieldSearcher {
    private static final Set<Operator> SUPPORTED_OPERATORS = ImmutableSet.of((Object)Operator.EQUALS, (Object)Operator.NOT_EQUALS, (Object)Operator.NOT_IN, (Object)Operator.IN);
    private final FieldVisibilityManager fieldVisibilityManager;
    private final JqlOperandResolver jqlOperandResolver;
    private final CustomFieldInputHelper customFieldInputHelper;
    private final CustomerOrganizationManager customerOrganizationManager;
    private final ServiceDeskOperationalStatus serviceDeskOperationalStatus;
    private final I18nHelper.BeanFactory i18nFactory;
    private final ServiceDeskUserLicenseService serviceDeskUserLicenseService;
    private final FeatureManager featureManager;
    private volatile CustomFieldSearcherInformation searcherInformation;
    private volatile SearchInputTransformer searchInputTransformer;
    private volatile SearchRenderer searchRenderer;
    private volatile CustomFieldSearcherClauseHandler customFieldSearcherClauseHandler;

    public CustomerOrganizationsSearcher(FieldVisibilityManager fieldVisibilityManager, JqlOperandResolver jqlOperandResolver, CustomFieldInputHelper customFieldInputHelper, CustomerOrganizationManager customerOrganizationManager, FeatureManager featureManager, ServiceDeskOperationalStatus serviceDeskOperationalStatus, I18nHelper.BeanFactory i18nFactory, ServiceDeskUserLicenseService serviceDeskUserLicenseService) {
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.jqlOperandResolver = jqlOperandResolver;
        this.customFieldInputHelper = customFieldInputHelper;
        this.customerOrganizationManager = customerOrganizationManager;
        this.serviceDeskOperationalStatus = serviceDeskOperationalStatus;
        this.i18nFactory = i18nFactory;
        this.serviceDeskUserLicenseService = serviceDeskUserLicenseService;
        this.featureManager = featureManager;
    }

    public void init(CustomField field) {
        SupportedOperatorsValidator supportedOperatorsValidator = new SupportedOperatorsValidator(new Collection[]{SUPPORTED_OPERATORS});
        CustomerOrganizationsIndexValuesConverter indexValuesConverter = new CustomerOrganizationsIndexValuesConverter(this.customerOrganizationManager);
        CustomerOrganizationsIndexer indexer = new CustomerOrganizationsIndexer(this.fieldVisibilityManager, field);
        ClauseNames clauseNames = field.getClauseNames();
        DefaultCustomFieldValueProvider valueProvider = new DefaultCustomFieldValueProvider();
        this.searcherInformation = new CustomFieldSearcherInformation(field.getId(), field.getNameKey(), Collections.singletonList(indexer), new AtomicReference<CustomField>(field));
        this.searchRenderer = new DummySearchRenderer(clauseNames, this.getDescriptor(), field, (CustomFieldValueProvider)valueProvider, this.fieldVisibilityManager);
        CustomerOrganizationsClauseValidator clauseValidator = new CustomerOrganizationsClauseValidator(supportedOperatorsValidator, this.jqlOperandResolver, this.serviceDeskOperationalStatus, this.i18nFactory, this.customerOrganizationManager, this.serviceDeskUserLicenseService, this.featureManager);
        this.searchInputTransformer = new CustomerOrganizationsSearchInputTransformer(field, this.searcherInformation.getId(), this.customFieldInputHelper, this.customerOrganizationManager, this.jqlOperandResolver, clauseNames, SUPPORTED_OPERATORS);
        this.customFieldSearcherClauseHandler = new SimpleCustomFieldContextValueGeneratingClauseHandler((ClauseValidator)clauseValidator, (ClauseQueryFactory)new JSDActualValueCustomFieldClauseQueryFactory(field.getId(), this.jqlOperandResolver, indexValuesConverter, true), (ClauseContextFactory)new SimpleClauseContextFactory(), (ClauseValuesGenerator)new CustomerOrganizationClauseValuesGenerator(this.customerOrganizationManager), SUPPORTED_OPERATORS, CustomerOrganizationsCFType.CUSTOMER_ORGANISATION_DATA_TYPE);
    }

    public SearcherInformation<CustomField> getSearchInformation() {
        if (this.searcherInformation == null) {
            throw new IllegalStateException("Attempt to retrieve SearcherInformation of uninitialised custom field searcher.");
        }
        return this.searcherInformation;
    }

    public SearchInputTransformer getSearchInputTransformer() {
        if (this.searchInputTransformer == null) {
            throw new IllegalStateException("Attempt to retrieve searchInputTransformer of uninitialised custom field searcher.");
        }
        return this.searchInputTransformer;
    }

    public SearchRenderer getSearchRenderer() {
        if (this.searchRenderer == null) {
            throw new IllegalStateException("Attempt to retrieve searchRenderer of uninitialised custom field searcher.");
        }
        return this.searchRenderer;
    }

    public CustomFieldSearcherClauseHandler getCustomFieldSearcherClauseHandler() {
        if (this.customFieldSearcherClauseHandler == null) {
            throw new IllegalStateException("Attempt to retrieve customFieldSearcherClauseHandler of uninitialised custom field searcher.");
        }
        return this.customFieldSearcherClauseHandler;
    }
}

