/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.customfields.organization;

import com.atlassian.jira.issue.customfields.searchers.transformer.AbstractCustomFieldSearchInputTransformer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.customfields.view.CustomFieldParamsImpl;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.SimpleNavigatorCollectorVisitor;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operator.Operator;
import com.atlassian.servicedesk.internal.feature.organization.CustomerOrganizationManager;
import com.atlassian.servicedesk.internal.feature.organization.util.CustomerOrganizationUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class CustomerOrganizationsSearchInputTransformer
extends AbstractCustomFieldSearchInputTransformer
implements SearchInputTransformer {
    private static final String ALL_FLAG_PARAM = "-1";
    private final CustomerOrganizationManager customerOrganizationManager;
    private final JqlOperandResolver jqlOperandResolver;
    private final ClauseNames clauseNames;
    private final Set<Operator> supportedOperators;

    public CustomerOrganizationsSearchInputTransformer(CustomField field, String urlParameterName, CustomFieldInputHelper customFieldInputHelper, CustomerOrganizationManager customerOrganizationManager, JqlOperandResolver jqlOperandResolver, ClauseNames clauseNames, Set<Operator> supportedOperators) {
        super(field, urlParameterName, customFieldInputHelper);
        this.customerOrganizationManager = customerOrganizationManager;
        this.jqlOperandResolver = jqlOperandResolver;
        this.clauseNames = clauseNames;
        this.supportedOperators = supportedOperators;
    }

    @Nullable
    protected Clause getClauseFromParams(ApplicationUser user, CustomFieldParams customFieldParams) {
        Collection searchValues = customFieldParams.getValuesForNullKey();
        Collection searchString = searchValues.stream().map(String::valueOf).collect(Collectors.toList());
        searchString.removeAll(CollectionBuilder.newBuilder((Object[])new String[]{ALL_FLAG_PARAM, ""}).asCollection());
        if (!searchString.isEmpty()) {
            return new TerminalClauseImpl(this.getClauseName(user, this.clauseNames), searchString.toArray(new String[searchString.size()]));
        }
        return null;
    }

    @Nullable
    protected CustomFieldParams getParamsFromSearchRequest(ApplicationUser user, Query query, SearchContext searchContext) {
        Set<String> rawOrganisationNames = this.getOrganisationNamesFromQuery(user, query);
        if (rawOrganisationNames.isEmpty()) {
            return null;
        }
        Set<Integer> validOrganisationIds = this.getValidOrganisationIds(rawOrganisationNames);
        if (validOrganisationIds.isEmpty()) {
            return null;
        }
        return new CustomFieldParamsImpl(this.getCustomField(), validOrganisationIds);
    }

    public boolean doRelevantClausesFitFilterForm(ApplicationUser user, Query query, SearchContext searchContext) {
        return false;
    }

    private Set<String> getOrganisationNamesFromQuery(ApplicationUser user, Query query) {
        if (query != null && query.getWhereClause() != null) {
            List literals;
            TerminalClause clause;
            SimpleNavigatorCollectorVisitor visitor = new SimpleNavigatorCollectorVisitor(this.clauseNames.getJqlFieldNames());
            query.getWhereClause().accept((ClauseVisitor)visitor);
            if (visitor.isValid() && visitor.getClauses().size() == 1 && this.isValidOperator((clause = (TerminalClause)visitor.getClauses().get(0)).getOperator()) && (literals = this.jqlOperandResolver.getValues(user, clause.getOperand(), clause)) != null) {
                LinkedHashSet<String> valuesAsStrings = new LinkedHashSet<String>();
                for (QueryLiteral literal : literals) {
                    valuesAsStrings.add(literal.asString());
                }
                return valuesAsStrings;
            }
        }
        return Collections.emptySet();
    }

    private Set<Integer> getValidOrganisationIds(Set<String> rawOrganisationNames) {
        return CustomerOrganizationUtil.transformToIds(this.customerOrganizationManager.getCustomerOrganizationByNames(rawOrganisationNames));
    }

    private boolean isValidOperator(Operator operator) {
        return this.supportedOperators.contains(operator);
    }
}

