/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.customfields.organization;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.pocketknife.annotations.lucene.LuceneUsage;
import com.atlassian.servicedesk.internal.feature.organization.util.CustomerOrganizationUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

@LuceneUsage(type=LuceneUsage.LuceneUsageType.Indexer)
public class CustomerOrganizationsIndexer
extends AbstractCustomFieldIndexer {
    protected CustomerOrganizationsIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField) {
        super(fieldVisibilityManager, customField);
    }

    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue);
    }

    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue);
    }

    private void addDocumentFields(Document doc, Issue issue) {
        Set<Integer> orgIds = this.getCustomerOrgsIds(issue);
        orgIds.forEach(id -> doc.add((Fieldable)new Field(this.getDocumentFieldId(), String.valueOf(id), Field.Store.NO, Field.Index.NOT_ANALYZED)));
    }

    private Set<Integer> getCustomerOrgsIds(Issue issue) {
        Object value = issue.getCustomFieldValue(this.customField);
        if (value instanceof Collection) {
            Collection orgs = (Collection)value;
            return CustomerOrganizationUtil.transformToIds(orgs);
        }
        return Collections.emptySet();
    }
}

