/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.customfields.organization;

import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypeImpl;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.impl.AbstractMultiCFType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.UserField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareCustomFieldType;
import com.atlassian.jira.issue.fields.rest.RestCustomFieldTypeOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.internal.customfields.CustomFieldIssueHelper;
import com.atlassian.servicedesk.internal.customfields.MultiCFTypeEqualityUtil;
import com.atlassian.servicedesk.internal.customfields.SDCustomfieldBulkEditSecurityHelper;
import com.atlassian.servicedesk.internal.customfields.organization.CustomerOrganizationCustomFieldOperationsHandler;
import com.atlassian.servicedesk.internal.customfields.util.FieldJsonBuilderAccessor;
import com.atlassian.servicedesk.internal.feature.organization.CustomerOrganizationManager;
import com.atlassian.servicedesk.internal.feature.organization.util.CustomerOrganizationUtil;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.rest.ServiceDeskJaxbJsonMashaller;
import com.atlassian.servicedesk.internal.rest.responses.CustomerOrganisationResponse;
import com.atlassian.servicedesk.internal.spi.jira.field.json.FieldJsonBuilderService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.util.StringUtils;

public class CustomerOrganizationsCFType
extends AbstractMultiCFType<CustomerOrganization>
implements UserField,
RestAwareCustomFieldType,
RestCustomFieldTypeOperations {
    private static final String JSON_SCHEMA_TYPE = "sd-customerorganization";
    @VisibleForTesting
    public static final String INVALID_IDS_ERROR_MESSAGE_KEY = "sd.customer.organisations.invalid.organisation.ids";
    @VisibleForTesting
    public static final String PROJECT_ID_IDENTIFIER = "com.atlassian.jira.internal.project_id";
    public static final JiraDataType CUSTOMER_ORGANISATION_DATA_TYPE = new JiraDataTypeImpl(CustomerOrganization.class);
    private static final String IS_FIELD_ENABLED_KEY = "isFieldEnabled";
    private static final String ORGANISATION_JSON_KEY = "organisationsJson";
    private static final String PROJECT_ID_KEY = "projectId";
    private final CustomerOrganizationManager customerOrganizationManager;
    private final ServiceDeskInternalManager serviceDeskManager;
    private final FeatureManager featureManager;
    private final CustomFieldIssueHelper customFieldIssueHelper;
    private final SDCustomfieldBulkEditSecurityHelper securityHelper;
    private final JiraBaseUrls jiraBaseUrls;
    private final FieldJsonBuilderAccessor fieldJsonBuilderAccessor;

    public CustomerOrganizationsCFType(CustomFieldValuePersister customFieldValuePersister, GenericConfigManager genericConfigManager, CustomerOrganizationManager customerOrganizationManager, ServiceDeskInternalManager serviceDeskManager, FeatureManager featureManager, CustomFieldIssueHelper customFieldIssueHelper, SDCustomfieldBulkEditSecurityHelper securityHelper, JiraBaseUrls jiraBaseUrls, FieldJsonBuilderAccessor fieldJsonBuilderAccessor) {
        super(customFieldValuePersister, genericConfigManager);
        this.customerOrganizationManager = customerOrganizationManager;
        this.serviceDeskManager = serviceDeskManager;
        this.featureManager = featureManager;
        this.customFieldIssueHelper = customFieldIssueHelper;
        this.securityHelper = securityHelper;
        this.jiraBaseUrls = jiraBaseUrls;
        this.fieldJsonBuilderAccessor = fieldJsonBuilderAccessor;
    }

    @Nullable
    protected Comparator<CustomerOrganization> getTypeComparator() {
        return null;
    }

    @Nullable
    protected Object convertTypeToDbValue(@Nullable CustomerOrganization organisation) {
        if (organisation == null) {
            return null;
        }
        return organisation.getId();
    }

    public Collection<CustomerOrganization> getValueFromIssue(CustomField field, Issue issue) {
        if (this.isFieldEnabled(issue)) {
            return ((Collection)Option.option((Object)super.getValueFromIssue(field, issue)).getOrElse(Collections.emptyList())).stream().filter(Objects::nonNull).collect(Collectors.toList());
        }
        return null;
    }

    @Nullable
    protected CustomerOrganization convertDbValueToType(@Nullable Object dbValue) {
        if (dbValue instanceof Double) {
            Integer value = ((Double)dbValue).intValue();
            return (CustomerOrganization)this.customerOrganizationManager.getOrganizationById(value).getOrNull();
        }
        return null;
    }

    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        if (bulkEditBean.isMultipleProjects()) {
            return "sd.customer.organisation.field.bulk.edit.mulitple.projects.unsupported";
        }
        Option<String> allowedForSDBulkEdit = this.securityHelper.isAllowedForSDBulkEdit(bulkEditBean);
        if (allowedForSDBulkEdit.isDefined()) {
            return (String)allowedForSDBulkEdit.get();
        }
        return null;
    }

    @Nonnull
    protected PersistenceFieldType getDatabaseType() {
        return PersistenceFieldType.TYPE_DECIMAL;
    }

    public String getStringFromSingularObject(CustomerOrganization organisation) {
        if (organisation == null) {
            return null;
        }
        return String.valueOf(organisation.getId());
    }

    @Nullable
    public CustomerOrganization getSingularObjectFromString(String value) throws FieldValidationException {
        if (StringUtils.isEmpty((Object)value)) {
            return null;
        }
        try {
            int intValue = Integer.parseInt(value);
            return (CustomerOrganization)this.customerOrganizationManager.getOrganizationById(intValue).getOrNull();
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public void validateFromParams(CustomFieldParams relevantParams, ErrorCollection errorCollectionToAddTo, FieldConfig config) {
        Set<Integer> existingIds;
        long projectId;
        HashSet<Integer> ids;
        Collection values2 = relevantParams.getValuesForNullKey();
        if (CollectionUtils.isNotEmpty((Collection)values2) && !(ids = new HashSet<Integer>(this.getIds(values2))).isEmpty() && relevantParams.getFirstValueForKey(PROJECT_ID_IDENTIFIER) != null && this.hasInvalidIds(ids, projectId = this.getProjectId(relevantParams), existingIds = this.getStoredValuesIds(relevantParams))) {
            errorCollectionToAddTo.addErrorMessage(this.getI18nBean().getText(INVALID_IDS_ERROR_MESSAGE_KEY));
        }
    }

    @Nullable
    public Collection<CustomerOrganization> getValueFromCustomFieldParams(CustomFieldParams parameters) throws FieldValidationException {
        Collection values2 = parameters.getValuesForNullKey();
        if (CollectionUtils.isEmpty((Collection)values2)) {
            return null;
        }
        List<Integer> ids = this.getIds(values2);
        return this.customerOrganizationManager.getOrganizationsById(ids);
    }

    public Object getStringValueFromCustomFieldParams(CustomFieldParams parameters) {
        return this.getValueFromCustomFieldParams(parameters);
    }

    @Nonnull
    public Map<String, Object> getVelocityParameters(Issue issue, CustomField field, FieldLayoutItem fieldLayoutItem) {
        if (issue == null) {
            return Collections.emptyMap();
        }
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            return Collections.emptyMap();
        }
        Map velocityParams = super.getVelocityParameters(issue, field, fieldLayoutItem);
        velocityParams.put(IS_FIELD_ENABLED_KEY, this.isFieldEnabled(issue));
        velocityParams.put(ORGANISATION_JSON_KEY, this.getOrganisationsAsJsonString((Collection<CustomerOrganization>)this.getValueFromIssue(field, issue)));
        velocityParams.put(PROJECT_ID_KEY, issue.getProjectId());
        return velocityParams;
    }

    public String getChangelogString(CustomField field, Collection<CustomerOrganization> values2) {
        if (CollectionUtils.isEmpty(values2)) {
            return "";
        }
        return values2.stream().filter(Objects::nonNull).map(CustomerOrganization::getName).collect(Collectors.joining(", "));
    }

    public boolean valuesEqual(@Nullable Collection<CustomerOrganization> existing, @Nullable Collection<CustomerOrganization> updated) {
        return MultiCFTypeEqualityUtil.valuesEqual(existing, updated);
    }

    private Set<Integer> getStoredValuesIds(CustomFieldParams relevantParams) {
        Option<Issue> issue = this.customFieldIssueHelper.getIssueFromCustomFieldParams(relevantParams);
        if (issue.isEmpty()) {
            return Collections.emptySet();
        }
        Collection existingOrgs = (Collection)((Issue)issue.get()).getCustomFieldValue(relevantParams.getCustomField());
        return CustomerOrganizationUtil.transformToIds(existingOrgs);
    }

    private long getProjectId(CustomFieldParams relevantParams) {
        return Long.valueOf(relevantParams.getFirstValueForKey(PROJECT_ID_IDENTIFIER).toString());
    }

    private boolean hasInvalidIds(Set<Integer> newIds, long projectId, Set<Integer> existingValuesIds) {
        ImmutableSet newIdsInProject = ImmutableSet.copyOf(this.customerOrganizationManager.filterOrganizationsInProject(newIds, projectId));
        Sets.SetView orgIdsNotInProject = Sets.difference(newIds, (Set)newIdsInProject);
        if (orgIdsNotInProject.isEmpty()) {
            return false;
        }
        return !existingValuesIds.containsAll((Collection<?>)orgIdsNotInProject);
    }

    private List<Integer> getIds(Collection<?> values2) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        values2.forEach(value -> {
            if (value instanceof Integer) {
                result.add((Integer)value);
            } else {
                result.add(Integer.valueOf(value.toString()));
            }
        });
        return result;
    }

    private boolean isFieldEnabled(Issue issue) {
        if (issue != null && issue.isCreated()) {
            return this.serviceDeskManager.isServiceDeskEnabled(issue.getProjectObject());
        }
        return false;
    }

    public String getOrganisationsAsJsonString(Collection<CustomerOrganization> organisations) {
        Option organisationsOpt = Option.option(organisations);
        Collection jsonResponse = ((Collection)organisationsOpt.getOrElse(Collections.emptyList())).stream().map(org -> new CustomerOrganisationResponse(org.getId(), org.getName())).collect(Collectors.toList());
        return new ServiceDeskJaxbJsonMashaller().marshal(jsonResponse);
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        return (FieldTypeInfo)Option.option((Object)fieldTypeInfoContext.getIssue()).flatMap(issue -> Option.option((Object)issue.getProjectId())).orElse(() -> Option.option((Object)fieldTypeInfoContext.getIssueContext()).flatMap(issueContext -> Option.option((Object)issueContext.getProjectId()))).fold(() -> new FieldTypeInfo(null, null), projectId -> {
            String orgAutoCompleteUrl = String.format("%s/rest/servicedesk/1/customer/organisations/project/%d/search?query=", this.jiraBaseUrls.baseUrl(), fieldTypeInfoContext.getIssue().getProjectId());
            return new FieldTypeInfo(null, orgAutoCompleteUrl);
        });
    }

    public JsonType getJsonSchema(CustomField customField) {
        return JsonTypeBuilder.customArray((String)JSON_SCHEMA_TYPE, (String)this.getKey(), (Long)customField.getIdAsLong());
    }

    public FieldJsonRepresentation getJsonFromIssue(CustomField customField, Issue issue, boolean renderedVersionRequested, @Nullable FieldLayoutItem fieldLayoutItem) {
        return this.mapOrganizationsToJsonable((Option<Collection<CustomerOrganization>>)Option.option((Object)this.getValueFromIssue(customField, issue)));
    }

    public RestFieldOperationsHandler getRestFieldOperation(CustomField customField) {
        return new CustomerOrganizationCustomFieldOperationsHandler(customField, this.getI18nBean());
    }

    public JsonData getJsonDefaultValue(IssueContext issueContext, CustomField customField) {
        FieldConfig config = customField.getRelevantConfig(issueContext);
        return this.mapOrganizationsToJsonable((Option<Collection<CustomerOrganization>>)Option.option((Object)this.getDefaultValue(config))).getStandardData();
    }

    private FieldJsonRepresentation mapOrganizationsToJsonable(Option<Collection<CustomerOrganization>> organizationsOption) {
        return (FieldJsonRepresentation)organizationsOption.fold(() -> this.fieldJsonBuilderAccessor.build(FieldJsonBuilderService::buildNullJson), organizations -> this.fieldJsonBuilderAccessor.build(fieldJsonService -> fieldJsonService.buildCustomerOrganizationsJson(organizations)));
    }
}

