/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.customfields.organization;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.customfields.service.CustomFieldException;
import com.atlassian.pocketknife.api.customfields.service.CustomFieldMetadata;
import com.atlassian.pocketknife.api.customfields.service.GlobalCustomFieldService;
import com.atlassian.servicedesk.JSDSuccess;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.customfields.organization.CustomerOrganizationsCFManager;
import com.atlassian.servicedesk.internal.customfields.organization.CustomerOrganizationsCFType;
import com.atlassian.servicedesk.internal.feature.organization.error.CustomerOrganizationError;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerOrganizationsCFManagerImpl
implements CustomerOrganizationsCFManager {
    private static final Logger LOG = LoggerFactory.getLogger(CustomerOrganizationsCFManagerImpl.class);
    private final FieldLayoutManager fieldLayoutManager;
    private final CustomerOrganizationError customerOrganizationError;
    private final CommonErrors commonErrors;
    private final IssueService issueService;
    private final GlobalCustomFieldService globalCustomFieldService;
    private final FeatureManager featureManager;
    private static final String CHANGE_LOG_VALUE_OPEN = "[";
    private static final String CHANGE_LOG_VALUE_CLOSE = "]";
    private final CustomFieldMetadata customFieldMetadata = CustomFieldMetadata.builder().fieldName("sd.customer.organisations.field.name").fieldDescription("sd.customer.organisations.desc").fieldType("com.atlassian.servicedesk:sd-customer-organizations").fieldSearcher("com.atlassian.servicedesk:sd-customer-organizations-searcher").lockField(true).build();

    @Autowired
    public CustomerOrganizationsCFManagerImpl(GlobalCustomFieldService globalCustomFieldService, FieldLayoutManager fieldLayoutManager, CustomerOrganizationError customerOrganizationError, CommonErrors commonErrors, IssueService issueService, FeatureManager featureManager) {
        this.globalCustomFieldService = globalCustomFieldService;
        this.fieldLayoutManager = fieldLayoutManager;
        this.customerOrganizationError = customerOrganizationError;
        this.commonErrors = commonErrors;
        this.issueService = issueService;
        this.featureManager = featureManager;
    }

    @Override
    public Option<CustomField> getOrCreateOrganizationsCF() {
        try {
            if (this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
                CustomField customField = this.globalCustomFieldService.getGlobalCustomField(this.customFieldMetadata);
                return Option.option((Object)customField);
            }
        }
        catch (CustomFieldException e) {
            LOG.error("error retrieving organizations CF", (Throwable)e);
        }
        return Option.none();
    }

    @Override
    public Either<AnError, Set<CustomerOrganization>> getOrganizationsFromIssue(@Nonnull Issue issue) {
        Objects.requireNonNull(issue, "issue");
        Option<CustomField> organizationsCFOpt = this.getOrCreateOrganizationsCF();
        if (!organizationsCFOpt.isDefined()) {
            return Either.left((Object)this.commonErrors.FEATURE_NOT_ENABLED());
        }
        CustomField organizationsCF = (CustomField)organizationsCFOpt.get();
        CustomerOrganizationsCFType cfType = (CustomerOrganizationsCFType)organizationsCF.getCustomFieldType();
        Collection organizations = (Collection)Option.option((Object)cfType.getValueFromIssue(organizationsCF, issue)).getOrElse(Collections.emptySet());
        return Either.right(new LinkedHashSet(organizations));
    }

    @Override
    public Either<AnError, JSDSuccess> updateField(@Nonnull CheckedUser user, @Nonnull Set<CustomerOrganization> organizations, @Nonnull Issue issue) {
        Objects.requireNonNull(user);
        Objects.requireNonNull(organizations);
        Objects.requireNonNull(issue);
        Option<CustomField> organizationsCFOpt = this.getOrCreateOrganizationsCF();
        if (!organizationsCFOpt.isDefined()) {
            return Either.left((Object)this.customerOrganizationError.ORGANISATIONS_CUSTOM_FIELD_NOT_FOUND());
        }
        CustomField organizationsCF = (CustomField)organizationsCFOpt.get();
        Option fieldLayoutItem = Option.option((Object)this.fieldLayoutManager.getFieldLayout(issue)).flatMap(fieldLayout -> Option.option((Object)fieldLayout.getFieldLayoutItem((OrderableField)organizationsCF)));
        if (fieldLayoutItem.isEmpty()) {
            return Either.left((Object)this.customerOrganizationError.FAILED_TO_UPDATE_ORGANISATIONS_CUSTOM_FIELD());
        }
        IssueInputParameters issueInputParameters = this.issueService.newIssueInputParameters();
        issueInputParameters.addCustomFieldValue(organizationsCF.getIdAsLong(), this.convertToInputValues(organizations));
        issueInputParameters.setSkipScreenCheck(true);
        issueInputParameters.setRetainExistingValuesWhenParameterNotProvided(true, true);
        IssueService.UpdateValidationResult updateValidationResult = this.issueService.validateUpdate(user.forJIRA(), issue.getId(), issueInputParameters);
        if (!updateValidationResult.isValid()) {
            return Either.left((Object)this.customerOrganizationError.FAILED_TO_UPDATE_ORGANISATIONS_CUSTOM_FIELD(updateValidationResult.getErrorCollection()));
        }
        IssueService.IssueResult issueResult = this.issueService.update(user.forJIRA(), updateValidationResult);
        if (!issueResult.isValid()) {
            return Either.left((Object)this.customerOrganizationError.FAILED_TO_UPDATE_ORGANISATIONS_CUSTOM_FIELD(issueResult.getErrorCollection()));
        }
        return Either.right((Object)((Object)JSDSuccess.success()));
    }

    @Override
    public Set<Integer> getAddedOrganizationIds(@Nonnull Collection<ChangeItemBean> changeItemBeans) {
        Option<CustomField> organizationCustomField = this.getOrCreateOrganizationsCF();
        if (organizationCustomField.isEmpty()) {
            return new HashSet<Integer>();
        }
        Option<ChangeItemBean> organizationChangeItem = this.getOrganizationChangeItem((CustomField)organizationCustomField.get(), changeItemBeans);
        if (organizationChangeItem.isEmpty()) {
            return Collections.emptySet();
        }
        return this.getAddedOrganizationIdsFromChangeItem((ChangeItemBean)organizationChangeItem.get());
    }

    private String[] convertToInputValues(Set<CustomerOrganization> organizations) {
        Set<String> strings = organizations.stream().map(org -> String.valueOf(org.getId())).collect(Collectors.toSet());
        return strings.toArray(new String[strings.size()]);
    }

    private Option<ChangeItemBean> getOrganizationChangeItem(CustomField organizationCustomField, Collection<ChangeItemBean> changeItemBeans) {
        Optional<ChangeItemBean> changeItemBean = changeItemBeans.stream().filter(changeItem -> Objects.equals(organizationCustomField.getFieldName(), changeItem.getField())).findFirst();
        return Option.fromOptional(changeItemBean);
    }

    private Set<Integer> getAddedOrganizationIdsFromChangeItem(ChangeItemBean changeItemBean) {
        Set<Integer> fromOrganizationIds = this.extractOrganizationIds(changeItemBean.getFrom());
        Set<Integer> toOrganizationIds = this.extractOrganizationIds(changeItemBean.getTo());
        toOrganizationIds.removeAll(fromOrganizationIds);
        return toOrganizationIds;
    }

    private Set<Integer> extractOrganizationIds(String changeLogValue) {
        if (changeLogValue == null) {
            return Collections.emptySet();
        }
        if (changeLogValue.length() < 2) {
            return Collections.emptySet();
        }
        if (!changeLogValue.startsWith(CHANGE_LOG_VALUE_OPEN) && !changeLogValue.endsWith(CHANGE_LOG_VALUE_CLOSE)) {
            return Collections.emptySet();
        }
        String valueString = changeLogValue.substring(1, changeLogValue.length() - 1);
        try {
            return Arrays.asList(valueString.split(",")).stream().map(String::trim).map(Integer::valueOf).collect(Collectors.toSet());
        }
        catch (NumberFormatException ex) {
            LOG.debug("Invalid change log value for Organization customfield: " + changeLogValue);
            return Collections.emptySet();
        }
    }
}

