/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.customfields.organization;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.impl.rest.AbstractCustomFieldOperationsHandler;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.rest.StandardOperation;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.atlassian.fugue.Functions;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

class CustomerOrganizationCustomFieldOperationsHandler
extends AbstractCustomFieldOperationsHandler<Collection<Integer>> {
    private static final Set<String> SUPPORTED_OPERATIONS = ImmutableSet.of((Object)StandardOperation.ADD.getName(), (Object)StandardOperation.SET.getName(), (Object)StandardOperation.REMOVE.getName());

    CustomerOrganizationCustomFieldOperationsHandler(CustomField field, I18nHelper i18nHelper) {
        super(field, i18nHelper);
    }

    public Set<String> getSupportedOperations() {
        return SUPPORTED_OPERATIONS;
    }

    protected Collection<Integer> getInitialValue(Issue issue, ErrorCollection errorCollection) {
        return ((Collection)Option.option((Object)this.field.getValue(issue)).map(toCast -> (Collection)toCast).getOrElse(Collections.emptyList())).stream().map(CustomerOrganization::getId).collect(Collectors.toList());
    }

    protected Collection<Integer> getInitialCreateValue(IssueContext issueContext) {
        return Collections.emptyList();
    }

    protected Collection<Integer> handleAddOperation(IssueContext issueCtx, Issue issue, Collection<Integer> currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        Option<Integer> integerIfNumber = CustomerOrganizationCustomFieldOperationsHandler.getIntegerIfNumber(operationValue.getData());
        if (integerIfNumber.isEmpty()) {
            errors.addError(this.field.getId(), this.i18nHelper.getText("rest.operation.must.be.number"), ErrorCollection.Reason.VALIDATION_FAILED);
            return currentFieldValue;
        }
        ImmutableList.Builder addOperationBuilder = ImmutableList.builder().addAll(currentFieldValue);
        int organizationIdToAdd = (Integer)integerIfNumber.get();
        if (!currentFieldValue.contains(organizationIdToAdd)) {
            addOperationBuilder.add((Object)organizationIdToAdd);
        }
        return addOperationBuilder.build();
    }

    protected Collection<Integer> handleRemoveOperation(IssueContext issueCtx, Issue issue, Collection<Integer> currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        Option<Integer> integerIfNumber = CustomerOrganizationCustomFieldOperationsHandler.getIntegerIfNumber(operationValue.getData());
        if (integerIfNumber.isEmpty()) {
            errors.addError(this.field.getId(), this.i18nHelper.getText("rest.operation.must.be.number"), ErrorCollection.Reason.VALIDATION_FAILED);
            return currentFieldValue;
        }
        int organizationIdToRemove = (Integer)integerIfNumber.get();
        return currentFieldValue.stream().filter(id -> !Objects.equals(organizationIdToRemove, id)).collect(Collectors.toList());
    }

    protected Collection<Integer> handleSetOperation(IssueContext issueCtx, Issue issue, Collection<Integer> currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        if (operationValue.isNull()) {
            return Collections.emptyList();
        }
        if (!operationValue.isArray()) {
            errors.addError(this.field.getId(), this.i18nHelper.getText("sd.customer.organizations.rest.operation.expected.array.error"), ErrorCollection.Reason.VALIDATION_FAILED);
            return Collections.emptyList();
        }
        ImmutableList.Builder setOperationBuilder = ImmutableList.builder();
        List rawValues = operationValue.asArray();
        for (int i = 0; i < rawValues.size(); ++i) {
            Object value = rawValues.get(i);
            Option<Integer> integerIfNumber = CustomerOrganizationCustomFieldOperationsHandler.getIntegerIfNumber(value);
            if (integerIfNumber.isEmpty()) {
                errors.addError(this.field.getId(), this.i18nHelper.getText("sd.customer.organizations.rest.operation.expected.array.of.numbers.error", (Object)i), ErrorCollection.Reason.VALIDATION_FAILED);
                return Collections.emptyList();
            }
            setOperationBuilder.add(integerIfNumber.get());
        }
        return setOperationBuilder.build();
    }

    protected void finaliseOperation(Collection<Integer> organizationIds, IssueInputParameters issueInputParameters, ErrorCollection errorCollection) {
        String[] stringIds = (String[])((Collection)Option.option(organizationIds).getOrElse(Collections.emptyList())).stream().filter(Objects::nonNull).map(String::valueOf).distinct().toArray(String[]::new);
        issueInputParameters.addCustomFieldValue(this.field.getId(), stringIds);
    }

    private static Option<Integer> getIntegerIfNumber(Object value) {
        return Option.option((Object)value).flatMap(Functions.isInstanceOf(Number.class)).map(Number::intValue);
    }
}

