/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.customfields.feedback;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.pocketknife.annotations.lucene.LuceneUsage;
import com.atlassian.servicedesk.bootstrap.lifecycle.ServiceDeskComponentAccessor;
import com.atlassian.servicedesk.internal.api.customfields.feedback.RequestFeedbackCFValue;
import com.atlassian.servicedesk.internal.util.SafeRunner;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

@LuceneUsage(type=LuceneUsage.LuceneUsageType.Indexer)
public class RequestFeedbackIndexer
extends AbstractCustomFieldIndexer {
    public RequestFeedbackIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField) {
        super(fieldVisibilityManager, customField);
    }

    public void addDocumentFieldsSearchable(final Document doc, final Issue issue) {
        this.getSafeRunner().run(new Runnable(){

            @Override
            public void run() {
                RequestFeedbackIndexer.this.addDocumentFields(doc, issue, Field.Index.NOT_ANALYZED_NO_NORMS);
            }
        });
    }

    public void addDocumentFieldsNotSearchable(final Document doc, final Issue issue) {
        this.getSafeRunner().run(new Runnable(){

            @Override
            public void run() {
                RequestFeedbackIndexer.this.addDocumentFields(doc, issue, Field.Index.NO);
            }
        });
    }

    private void addDocumentFields(Document doc, Issue issue, Field.Index index) {
        Object value = issue.getCustomFieldValue(this.customField);
        if (value != null) {
            RequestFeedbackCFValue feedbackCFValue = (RequestFeedbackCFValue)value;
            doc.add((Fieldable)new Field(this.getDocumentFieldId(), String.valueOf(feedbackCFValue.getRate()), Field.Store.YES, index));
        }
    }

    private SafeRunner getSafeRunner() {
        return ServiceDeskComponentAccessor.getSafeRunner();
    }
}

