/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.customfields.feedback;

import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.util.IndexValueConverter;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.SupportedOperatorsValidator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.Operand;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;

public class RequestFeedbackCFValidator
implements ClauseValidator {
    private final SupportedOperatorsValidator supportedOperatorsValidator;
    private final JqlOperandResolver jqlOperandResolver;
    private final I18nHelper.BeanFactory beanFactory;
    private IndexValueConverter indexValueConverter;

    public RequestFeedbackCFValidator(JqlOperandResolver jqlOperandResolver, IndexValueConverter indexValueConverter, I18nHelper.BeanFactory beanFactory) {
        this.beanFactory = (I18nHelper.BeanFactory)Assertions.notNull((String)"beanFactory", (Object)beanFactory);
        this.jqlOperandResolver = (JqlOperandResolver)Assertions.notNull((String)"jqlOperandResolver", (Object)jqlOperandResolver);
        this.supportedOperatorsValidator = this.getSupportedOperatorsValidator();
        this.indexValueConverter = indexValueConverter;
    }

    @Nonnull
    public MessageSet validate(ApplicationUser searcher, @Nonnull TerminalClause terminalClause) {
        MessageSet errors = this.supportedOperatorsValidator.validate(searcher, terminalClause);
        if (!errors.hasAnyErrors()) {
            errors = this.validateValue(searcher, terminalClause);
        }
        return errors;
    }

    public MessageSet validateValue(ApplicationUser searcher, TerminalClause terminalClause) {
        Operand operand = terminalClause.getOperand();
        MessageSetImpl messageSet = new MessageSetImpl();
        List literals = this.jqlOperandResolver.getValues(searcher, operand, terminalClause);
        if (literals != null) {
            for (QueryLiteral literal : literals) {
                if (literal.isEmpty() || this.indexValueConverter.convertToIndexValue(literal) != null) continue;
                this.addError(searcher, (MessageSet)messageSet, terminalClause, literal);
            }
        }
        return messageSet;
    }

    void addError(ApplicationUser searcher, MessageSet messageSet, TerminalClause terminalClause, QueryLiteral literal) {
        String fieldName = terminalClause.getName();
        if (this.jqlOperandResolver.isFunctionOperand(literal.getSourceOperand())) {
            messageSet.addErrorMessage(this.getI18nHelper(searcher).getText("jira.jql.clause.invalid.number.value.function", literal.getSourceOperand().getName(), fieldName));
        } else {
            messageSet.addErrorMessage(this.getI18nHelper(searcher).getText("jira.jql.clause.invalid.number.value", fieldName, literal.asString()));
        }
    }

    SupportedOperatorsValidator getSupportedOperatorsValidator() {
        return new SupportedOperatorsValidator(new Collection[]{OperatorClasses.EQUALITY_AND_RELATIONAL_WITH_EMPTY});
    }

    I18nHelper getI18nHelper(ApplicationUser user) {
        return this.beanFactory.getInstance(user);
    }
}

