/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.customfields.feedback;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.impl.AbstractSingleFieldType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.servicedesk.bootstrap.lifecycle.ServiceDeskComponentAccessor;
import com.atlassian.servicedesk.internal.api.customfields.feedback.RequestFeedbackCFManager;
import com.atlassian.servicedesk.internal.api.customfields.feedback.RequestFeedbackCFValue;
import com.atlassian.servicedesk.internal.api.util.SoyTemplateRenderer;
import com.atlassian.servicedesk.internal.user.license.ServiceDeskUserLicenseService;
import com.atlassian.servicedesk.internal.util.JsonSerializer;
import io.atlassian.fugue.Option;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class RequestFeedbackCFType
extends AbstractSingleFieldType<RequestFeedbackCFValue> {
    private static final String CAN_VIEW = "canView";
    private static final String TEMPLATE = "template";
    private static final String MODULE = "module";
    private static final String SOY_CONTEXT = "soyContext";
    private static final String SOY_RENDERER = "soyRenderer";
    private static final String FEEDBACK_DATA = "feedbackData";
    private final JsonSerializer<RequestFeedbackCFValue> serializer = new JsonSerializer<RequestFeedbackCFValue>(RequestFeedbackCFValue.class);
    private final I18nHelper i18nHelper;
    private final JiraAuthenticationContext authenticationContext;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final RequestFeedbackCFManager requestFeedbackCFManager;

    public RequestFeedbackCFType(CustomFieldValuePersister customFieldValuePersister, GenericConfigManager genericConfigManager, I18nHelper i18nHelper, JiraAuthenticationContext authenticationContext, SoyTemplateRenderer soyTemplateRenderer, RequestFeedbackCFManager requestFeedbackCFManager) {
        super(customFieldValuePersister, genericConfigManager);
        this.i18nHelper = i18nHelper;
        this.authenticationContext = authenticationContext;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.requestFeedbackCFManager = requestFeedbackCFManager;
    }

    @Nonnull
    protected PersistenceFieldType getDatabaseType() {
        return PersistenceFieldType.TYPE_LIMITED_TEXT;
    }

    protected Object getDbValueFromObject(RequestFeedbackCFValue value) {
        return this.serializer.serialize(value);
    }

    protected RequestFeedbackCFValue getObjectFromDbValue(@Nonnull Object o) throws FieldValidationException {
        if (o instanceof String) {
            return this.serializer.deserialize((String)o);
        }
        return null;
    }

    public String getStringFromSingularObject(RequestFeedbackCFValue value) {
        return value.getRate().toString();
    }

    public RequestFeedbackCFValue getSingularObjectFromString(String s) throws FieldValidationException {
        RequestFeedbackCFValue value = new RequestFeedbackCFValue();
        try {
            value.setRate(Integer.valueOf(s));
        }
        catch (NumberFormatException ex) {
            throw new FieldValidationException(this.i18nHelper.getText("sd.request.feedback.error.invalid.input"));
        }
        return value;
    }

    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        return "sd.request.feedback.bulk.edit.unsupported";
    }

    @Nonnull
    public Map<String, Object> getVelocityParameters(Issue issue, CustomField field, FieldLayoutItem fieldLayoutItem) {
        Map values2 = super.getVelocityParameters(issue, field, fieldLayoutItem);
        HashMap<String, Object> soyContext = new HashMap<String, Object>();
        Option value = Option.none();
        if (issue != null) {
            value = this.requestFeedbackCFManager.getRequestFeedback(issue);
        }
        soyContext.put(CAN_VIEW, this.canView());
        soyContext.put(FEEDBACK_DATA, value.getOrNull());
        values2.put(MODULE, "com.atlassian.servicedesk:soy");
        values2.put(TEMPLATE, "ServiceDesk.Templates.RequestFeedback.columnView");
        values2.put(SOY_RENDERER, this.soyTemplateRenderer);
        values2.put(SOY_CONTEXT, soyContext);
        return values2;
    }

    public String getChangelogValue(CustomField field, RequestFeedbackCFValue value) {
        return null;
    }

    private boolean canView() {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        ServiceDeskUserLicenseService sdUserLicenseService = ServiceDeskComponentAccessor.getServiceDeskUserLicenseService();
        return sdUserLicenseService.hasValidAgentLicense(user);
    }
}

