/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.customfields.feedback;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.customfields.service.CustomFieldException;
import com.atlassian.pocketknife.api.customfields.service.CustomFieldMetadata;
import com.atlassian.pocketknife.api.customfields.service.GlobalCustomFieldService;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.internal.api.customfields.feedback.RequestFeedbackCFManager;
import com.atlassian.servicedesk.internal.api.customfields.feedback.RequestFeedbackCFValue;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class RequestFeedbackCFManagerImpl
implements RequestFeedbackCFManager {
    protected final Log log = Log.with(this.getClass());
    private final CustomFieldMetadata customFieldMetaData = CustomFieldMetadata.builder().fieldName("sd.request.feedback.name").fieldDescription("sd.request.feedback.desc").fieldType("com.atlassian.servicedesk:sd-request-feedback").fieldSearcher("com.atlassian.servicedesk:sd-request-feedback-searcher").lockField(true).build();
    @Autowired
    private GlobalCustomFieldService globalCustomFieldService;

    public Option<CustomField> getOrCreateRequestFeedbackCF() {
        try {
            CustomField feedbackCF = this.globalCustomFieldService.getGlobalCustomField(this.customFieldMetaData);
            return Option.some((Object)feedbackCF);
        }
        catch (CustomFieldException e) {
            this.log.error(e.getMessage(), new Object[0]);
            return Option.none();
        }
    }

    public Option<RequestFeedbackCFValue> getRequestFeedback(Issue issue) {
        Option<CustomField> feedbackCFOpt = this.getOrCreateRequestFeedbackCF();
        return Steps.begin(feedbackCFOpt).then(feedbackCF -> Option.option((Object)feedbackCF.getValue(issue))).yield((feedbackCFt, value) -> (RequestFeedbackCFValue)value);
    }
}

