/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.customfields;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomFieldIssueHelper {
    private static final String ISSUE_ID_IDENTIFIER = "com.atlassian.jira.internal.issue_id";
    private final IssueManager issueManager;

    @Autowired
    public CustomFieldIssueHelper(IssueManager issueManager) {
        this.issueManager = issueManager;
    }

    public Option<Issue> getIssueFromCustomFieldParams(CustomFieldParams relevantParams) {
        Object issueIdObj = relevantParams.getFirstValueForKey(ISSUE_ID_IDENTIFIER);
        if (issueIdObj != null && issueIdObj instanceof String) {
            Long issueId = Long.decode((String)issueIdObj);
            MutableIssue issue = this.issueManager.getIssueObject(issueId);
            return Option.option((Object)issue);
        }
        return Option.none();
    }
}

