/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.customer.request;

import com.atlassian.servicedesk.internal.api.webfragments.WebInterfaceBeanService;
import com.atlassian.servicedesk.internal.api.webfragments.WebPanelBean;
import com.atlassian.servicedesk.internal.customer.request.CustomerRequestContext;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerRequestPanelService {
    private static final String TOP_PANEL_LOCATION = "request-content-top";
    private static final String INTERNAL_OPTION_PANEL_LOCATION = "request-options";
    private static final String PUBLIC_OPTION_PANEL_LOCATION = "servicedesk.portal.request.panels";
    private final WebInterfaceBeanService webInterfaceBeanService;

    @Autowired
    public CustomerRequestPanelService(WebInterfaceBeanService webInterfaceBeanService) {
        this.webInterfaceBeanService = webInterfaceBeanService;
    }

    public List<WebPanelBean> getTopPanels(CustomerRequestContext context) {
        Map<String, Object> contextMap = context.toMap();
        return this.webInterfaceBeanService.getWebPanels(TOP_PANEL_LOCATION, contextMap);
    }

    public List<WebPanelBean> getOptionPanels(CustomerRequestContext context) {
        Map<String, Object> contextMap = context.toMap();
        return ImmutableList.builder().addAll((Iterable)this.webInterfaceBeanService.getWebPanels(INTERNAL_OPTION_PANEL_LOCATION, contextMap)).addAll((Iterable)this.webInterfaceBeanService.getWebPanels(PUBLIC_OPTION_PANEL_LOCATION, contextMap)).build();
    }
}

