/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.customer.request;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.internal.api.webfragments.ConnectContextKeyMappings;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class CustomerRequestContext {
    private final ApplicationUser user;
    private final ServiceDesk serviceDesk;
    private final Portal portal;
    private final Issue issue;
    private final Long requestTypeId;

    public CustomerRequestContext(ApplicationUser user, ServiceDesk serviceDesk, Portal portal, Issue issue, Long requestTypeId) {
        this.user = user;
        this.serviceDesk = serviceDesk;
        this.portal = portal;
        this.issue = issue;
        this.requestTypeId = requestTypeId;
    }

    public ServiceDesk getServiceDesk() {
        return this.serviceDesk;
    }

    public Portal getPortal() {
        return this.portal;
    }

    public Issue getIssue() {
        return this.issue;
    }

    public ApplicationUser getUser() {
        return this.user;
    }

    public Long getRequestTypeId() {
        return this.requestTypeId;
    }

    public Map<String, Object> toMap() {
        return ImmutableMap.builder().put((Object)"issue", (Object)this.issue).put((Object)"portal", (Object)this.portal).put((Object)"serviceDesk", (Object)this.serviceDesk).put((Object)"user", (Object)this.user).put((Object)ConnectContextKeyMappings.REQUEST_ID.getUiKey(), (Object)this.issue.getId()).put((Object)ConnectContextKeyMappings.REQUEST_TYPE_ID.getUiKey(), (Object)this.requestTypeId).put((Object)ConnectContextKeyMappings.SERVICE_DESK_ID.getUiKey(), (Object)this.serviceDesk.getId()).build();
    }
}

