/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.customer.portal;

import com.atlassian.servicedesk.internal.api.webfragments.PagePanels;
import com.atlassian.servicedesk.internal.api.webfragments.PanelPosition;
import com.atlassian.servicedesk.internal.api.webfragments.PortalPage;
import com.atlassian.servicedesk.internal.api.webfragments.WebInterfaceBeanService;
import com.atlassian.servicedesk.internal.api.webfragments.WebPanelBean;
import com.atlassian.servicedesk.internal.customer.PortalContext;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortalWebFragmentsService {
    private final WebInterfaceBeanService webInterfaceBeanService;

    @Autowired
    public PortalWebFragmentsService(WebInterfaceBeanService webInterfaceBeanService) {
        this.webInterfaceBeanService = webInterfaceBeanService;
    }

    public List<WebPanelBean> getHeaderPanels(PortalContext context, PortalPage portalPage) {
        return ImmutableList.builder().addAll((Iterable)this.webInterfaceBeanService.getWebPanels(PanelPosition.HEADER.getLocation(), context.toMap())).addAll((Iterable)this.webInterfaceBeanService.getWebPanels(PanelPosition.HEADER.getLocationFor(portalPage), context.toMap())).build();
    }

    public List<WebPanelBean> getSubheaderPanels(PortalContext context, PortalPage portalPage) {
        return ImmutableList.builder().addAll((Iterable)this.webInterfaceBeanService.getWebPanels(PanelPosition.SUBHEADER.getLocation(), context.toMap())).addAll((Iterable)this.webInterfaceBeanService.getWebPanels(PanelPosition.SUBHEADER.getLocationFor(portalPage), context.toMap())).build();
    }

    public List<WebPanelBean> getFooterPanels(PortalContext context, PortalPage portalPage) {
        return ImmutableList.builder().addAll((Iterable)this.webInterfaceBeanService.getWebPanels(PanelPosition.FOOTER.getLocation(), context.toMap())).addAll((Iterable)this.webInterfaceBeanService.getWebPanels(PanelPosition.FOOTER.getLocationFor(portalPage), context.toMap())).build();
    }

    public Map<String, List<WebPanelBean>> getPagePanels(PortalContext context, PortalPage portalPage) {
        return PagePanels.getLocationsForPage((PortalPage)portalPage).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.webInterfaceBeanService.getWebPanels((String)entry.getValue(), context.toMap())));
    }
}

