/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.customer.context.urimatching;

import com.atlassian.servicedesk.internal.customer.context.urimatching.UriMatch;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UriMatchParser {
    private static final Logger log = LoggerFactory.getLogger(UriMatchParser.class);

    public static Option<UriMatch> parseUriMatch(Element element) {
        String path = element.attributeValue("path", "");
        if (StringUtils.isBlank((String)(path = UriMatchParser.normalise(path)))) {
            return Option.none();
        }
        UriMatch.Builder builder = UriMatch.builder().startsWith(path);
        boolean blackList = Boolean.valueOf(element.attributeValue("blacklist", "false"));
        if (blackList) {
            builder.setBlackList();
        }
        List entries = element.elements("uri");
        for (Element entry : entries) {
            String regex = entry.attributeValue("regex");
            if (!StringUtils.isNotBlank((String)regex)) continue;
            Pattern pattern = null;
            try {
                pattern = Pattern.compile(regex);
                builder.addPattern(pattern);
            }
            catch (Exception ignored) {
                log.debug(String.format("Unable to interpret UriMatch regex %s", regex));
            }
        }
        return Option.some((Object)builder.build());
    }

    private static String normalise(String path) {
        if (!(path = StringUtils.defaultIfBlank((String)StringUtils.strip((String)path), (String)"")).startsWith("/")) {
            path = "/" + path;
        }
        if (path.endsWith("/")) {
            path = StringUtils.substring((String)path, (int)0, (int)(path.length() - 1));
        }
        return path;
    }
}

