/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.customer;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.request.CustomerRequest;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.internal.api.webfragments.ConnectContextKeyMappings;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class PortalContext {
    @Nullable
    private final ApplicationUser user;
    @Nullable
    private final ServiceDesk serviceDesk;
    @Nullable
    private final Portal portal;
    @Nullable
    private final Issue issue;
    @Nullable
    private final CustomerRequest customerRequest;
    @Nullable
    private final RequestType requestType;

    private PortalContext(ApplicationUser user, ServiceDesk serviceDesk, Portal portal, Issue issue, CustomerRequest customerRequest, RequestType requestType) {
        this.user = user;
        this.serviceDesk = serviceDesk;
        this.portal = portal;
        this.issue = issue;
        this.customerRequest = customerRequest;
        this.requestType = requestType;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.user != null) {
            map.put("user", this.user);
        }
        if (this.portal != null) {
            map.put("portal", this.portal);
        }
        if (this.serviceDesk != null) {
            map.put("serviceDesk", this.serviceDesk);
            map.put(ConnectContextKeyMappings.SERVICE_DESK_ID.getUiKey(), this.serviceDesk.getId());
        }
        if (this.issue != null) {
            map.put("issue", this.issue);
        }
        if (this.customerRequest != null) {
            map.put("customerRequest", this.customerRequest);
            map.put(ConnectContextKeyMappings.REQUEST_ID.getUiKey(), this.customerRequest.getIssue().getId());
        }
        if (this.requestType != null) {
            map.put("requestType", this.requestType);
            map.put(ConnectContextKeyMappings.REQUEST_TYPE_ID.getUiKey(), this.requestType.getId());
        }
        return map;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ApplicationUser user;
        private ServiceDesk serviceDesk;
        private Portal portal;
        private Issue issue;
        private CustomerRequest customerRequest;
        private RequestType requestType;

        private Builder() {
        }

        public Builder setUser(ApplicationUser user) {
            this.user = user;
            return this;
        }

        public Builder setServiceDesk(ServiceDesk serviceDesk) {
            this.serviceDesk = serviceDesk;
            return this;
        }

        public Builder setPortal(Portal portal) {
            this.portal = portal;
            return this;
        }

        public Builder setIssue(Issue issue) {
            this.issue = issue;
            return this;
        }

        public Builder setCustomerRequest(CustomerRequest customerRequest) {
            this.customerRequest = customerRequest;
            return this;
        }

        public Builder setRequestType(RequestType requestType) {
            this.requestType = requestType;
            return this;
        }

        public PortalContext build() {
            return new PortalContext(this.user, this.serviceDesk, this.portal, this.issue, this.customerRequest, this.requestType);
        }
    }
}

