/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.confluenceknowledgebase.search;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.internal.api.applink.ApplicationLinkErrors;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseLink;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.ConfluencePage;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.ConfluenceSpace;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.errors.ConfluenceKBErrors;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.responses.ConfluenceKBContentResponse;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.search.BaseConfluenceAppLinkResponseHandler;
import com.atlassian.servicedesk.internal.rest.responses.kb.ConfluenceKBSpaceResponse;
import io.atlassian.fugue.Either;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;

@ParametersAreNonnullByDefault
public class ConfluencePageAppLinkResponseHandler
extends BaseConfluenceAppLinkResponseHandler<ConfluencePage> {
    private static final String PAGE_TYPE = "page";
    private final ApplicationLink applicationLink;
    private final String path;
    private final List<ConfluenceKnowledgeBaseLink> confluenceKBLinks;

    public ConfluencePageAppLinkResponseHandler(ApplicationLink applicationLink, String path, List<ConfluenceKnowledgeBaseLink> confluenceKBLinks, ErrorResultHelper errorResultHelper, ConfluenceKBErrors confluenceKbErrors, ApplicationLinkErrors applicationLinkErrors) {
        super(errorResultHelper, confluenceKbErrors, applicationLinkErrors);
        this.confluenceKBLinks = confluenceKBLinks;
        this.applicationLink = applicationLink;
        this.path = path;
    }

    public Either<AnError, ConfluencePage> onSuccess(String responseBody) {
        if (responseBody == null) {
            return Either.left((Object)this.confluenceKBErrors.CONFLUENCE_COMMUNICATION_ERROR());
        }
        try {
            ConfluenceKBContentResponse confluencePageResponse = (ConfluenceKBContentResponse)new ObjectMapper().readValue(responseBody, ConfluenceKBContentResponse.class);
            Long pageId = confluencePageResponse.getId();
            String type = confluencePageResponse.getType();
            if (StringUtils.isNotBlank((String)type) && !type.equalsIgnoreCase(PAGE_TYPE)) {
                log.debug("Could not find the confluence page - ID: {}, type: {}, responseBody: {}", new Object[]{pageId, type, responseBody});
                return Either.left((Object)this.confluenceKBErrors.CONFLUENCE_PAGE_NOT_FOUND_ERROR());
            }
            ConfluenceKBSpaceResponse confluenceKBSpaceResponse = confluencePageResponse.getConfluenceKBSpaceResponse();
            if (confluenceKBSpaceResponse == null) {
                log.debug("Confluence returned a response when service desk requested a page but the 'space' property was missing.");
                return Either.left((Object)this.confluenceKBErrors.CONFLUENCE_COMMUNICATION_ERROR());
            }
            Either<AnError, String> remoteUrlEither = this.getRemoteUrl(this.applicationLink, pageId);
            if (remoteUrlEither.isLeft()) {
                return Either.left((Object)remoteUrlEither.left().get());
            }
            String remoteUrl = (String)remoteUrlEither.right().get();
            ConfluenceSpace confluenceSpace = new ConfluenceSpace(confluenceKBSpaceResponse.getKey(), confluenceKBSpaceResponse.getName());
            List<Integer> relevantServiceDesks = this.confluenceKBLinks.stream().filter(kbLink -> this.spaceKeyValidAndEquals(kbLink.getSpaceKey(), confluenceSpace.getKey())).map(ConfluenceKnowledgeBaseLink::getServiceDeskId).collect(Collectors.toList());
            ConfluencePage confluenceKnowledgeBaseArticle = new ConfluencePage(pageId, confluencePageResponse.getTitle(), remoteUrl, confluenceSpace, relevantServiceDesks, this.applicationLink.getId().toString());
            return Either.right((Object)confluenceKnowledgeBaseArticle);
        }
        catch (IOException | ClassCastException ex) {
            log.debug("Failed to complete operation, most likely because of a problem deserialising the response from Confluence: " + ex.getMessage());
            return Either.left((Object)this.confluenceKBErrors.CONFLUENCE_COMMUNICATION_ERROR());
        }
    }

    private boolean spaceKeyValidAndEquals(@Nullable String spaceKey, @Nullable String spaceKeyToCompare) {
        return spaceKey != null && spaceKeyToCompare != null && spaceKey.equals(spaceKeyToCompare);
    }
}

