/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.confluenceknowledgebase.search;

import com.atlassian.fugue.Either;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.customer.CustomerContextService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.search.ConfluenceKBInternalSearchService;
import com.atlassian.servicedesk.workinprogressapi.kb.KnowledgeBaseArticle;
import com.atlassian.servicedesk.workinprogressapi.kb.KnowledgeBaseSearchQuery;
import com.atlassian.servicedesk.workinprogressapi.kb.KnowledgeBaseSearchService;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class ConfluenceKBSearchService
implements KnowledgeBaseSearchService {
    private final UserFactory userFactory;
    private final CustomerContextService customerContextService;
    private final ConfluenceKBInternalSearchService confluenceKBInternalSearchService;

    @Autowired
    public ConfluenceKBSearchService(@Nonnull UserFactory userFactory, @Nonnull CustomerContextService customerContextService, @Nonnull ConfluenceKBInternalSearchService confluenceKBInternalSearchService) {
        this.userFactory = userFactory;
        this.customerContextService = customerContextService;
        this.confluenceKBInternalSearchService = confluenceKBInternalSearchService;
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<AnError, List<KnowledgeBaseArticle>> search(@Nonnull ApplicationUser user, @Nonnull KnowledgeBaseSearchQuery query) {
        Validate.notNull((Object)user, (String)"user cannot be null");
        Validate.notNull((Object)query, (String)"query cannot be null");
        return StepsConverters.newerEither((Either)this.userFactory.wrap(user)).flatMap(checkedUser -> this.confluenceKBInternalSearchService.search((CheckedUser)checkedUser, query.getSearchText()));
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<AnError, List<KnowledgeBaseArticle>> searchAsCustomer(@Nonnull ApplicationUser user, @Nonnull KnowledgeBaseSearchQuery query) {
        Validate.notNull((Object)user, (String)"user cannot be null");
        Validate.notNull((Object)query, (String)"query cannot be null");
        return (io.atlassian.fugue.Either)this.customerContextService.runInCustomerContext(() -> this.search(user, query));
    }
}

