/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.confluenceknowledgebase.search;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.application.confluence.ConfluenceApplicationType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.applink.ApplicationLinkErrors;
import com.atlassian.servicedesk.internal.api.applink.BaseAppLinkResponseHandler;
import com.atlassian.servicedesk.internal.api.feature.applink.ServiceDeskAppLinkService;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseInternalService;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseLink;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.ConfluenceKnowledgeBaseManager;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.ConfluencePage;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.errors.ConfluenceKBErrors;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.search.ConfluenceKBInternalSearchService;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.search.ConfluencePageAppLinkResponseHandler;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.search.ConfluenceSearchAppLinkResponseHandler;
import com.atlassian.servicedesk.internal.errors.ServiceDeskHttpError;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.utils.Convert;
import com.atlassian.servicedesk.workinprogressapi.kb.KnowledgeBaseArticle;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfluenceKBInternalSearchServiceImpl
implements ConfluenceKBInternalSearchService {
    private static Logger log = LoggerFactory.getLogger(ConfluenceKBInternalSearchServiceImpl.class);
    private final ConfluenceKnowledgeBaseInternalService confluenceKnowledgeBaseService;
    private final ConfluenceKnowledgeBaseManager confluenceKnowledgeBaseManager;
    private final ServiceDeskAppLinkService serviceDeskAppLinkService;
    private final InternalPortalService portalService;
    private final ProjectManager projectManager;
    private final InternalServiceDeskService serviceDeskService;
    private final ErrorResultHelper errorResultHelper;
    private final ConfluenceKBErrors confluenceKbErrors;
    private ApplicationLinkErrors applicationLinkErrors;

    @Autowired
    public ConfluenceKBInternalSearchServiceImpl(ConfluenceKnowledgeBaseInternalService confluenceKnowledgeBaseService, ConfluenceKnowledgeBaseManager confluenceKnowledgeBaseManager, ServiceDeskAppLinkService serviceDeskAppLinkService, InternalPortalService internalPortalService, ProjectManager projectManager, InternalServiceDeskService serviceDeskService, ErrorResultHelper errorResultHelper, ConfluenceKBErrors confluenceKbErrors, ApplicationLinkErrors applicationLinkErrors) {
        this.confluenceKnowledgeBaseService = confluenceKnowledgeBaseService;
        this.confluenceKnowledgeBaseManager = confluenceKnowledgeBaseManager;
        this.serviceDeskAppLinkService = serviceDeskAppLinkService;
        this.portalService = internalPortalService;
        this.projectManager = projectManager;
        this.serviceDeskService = serviceDeskService;
        this.errorResultHelper = errorResultHelper;
        this.confluenceKbErrors = confluenceKbErrors;
        this.applicationLinkErrors = applicationLinkErrors;
    }

    @Override
    @Nonnull
    public Either<AnError, List<KnowledgeBaseArticle>> search(@Nonnull CheckedUser user, @Nonnull String query) {
        List<Portal> portals = this.portalService.getCustomerVisiblePortals(user);
        ArrayList projectIds = Lists.newArrayList();
        projectIds.addAll(portals.stream().map(this.portalService::getProjectIdForPortal).collect(Collectors.toList()));
        List projects = this.projectManager.convertToProjectObjects((Collection)projectIds);
        List visibleServiceDesks = this.serviceDeskService.getServiceDeskByVisiblePortalAsCustomer(user, portals);
        return Steps.begin((Either)this.serviceDeskAppLinkService.getPrimaryApplicationLinkForType(ConfluenceApplicationType.class)).then(applicationLink -> this.confluenceKnowledgeBaseService.getPrimaryOrFirstAssociatedAppLink(visibleServiceDesks, applicationLink.getId().get())).then((applicationLink, confluenceKBLink) -> this.confluenceKnowledgeBaseService.getArticleSearchPathForSharedPortal(user, query, confluenceKBLink.getApplicationId(), visibleServiceDesks)).then((applicationLink, confluenceKBLink, articlesSearchPath) -> this.serviceDeskAppLinkService.makeGetRequestForMultipleProjects(user, projects, confluenceKBLink.getApplicationId(), articlesSearchPath, (BaseAppLinkResponseHandler)this.getResponseHandler((ConfluenceKnowledgeBaseLink)confluenceKBLink, (String)articlesSearchPath))).yield((applicationLink, confluenceKBLink, articlesSearchPath, kbArticles) -> kbArticles);
    }

    private ConfluenceSearchAppLinkResponseHandler getResponseHandler(ConfluenceKnowledgeBaseLink confluenceKBLink, String articlesSearchPath) {
        return new ConfluenceSearchAppLinkResponseHandler(confluenceKBLink, articlesSearchPath, this.errorResultHelper, this.confluenceKbErrors, this.applicationLinkErrors);
    }

    @Override
    @Nonnull
    public Either<AnError, ConfluencePage> find(CheckedUser user, Long pageId, String applicationLinkId) {
        Either applicationLinkEither = this.serviceDeskAppLinkService.getApplicationLink(applicationLinkId);
        if (applicationLinkEither.isLeft()) {
            return Either.left((Object)applicationLinkEither.left().get());
        }
        ApplicationLink applicationLink = (ApplicationLink)applicationLinkEither.right().get();
        return this.find(user, applicationLink, pageId);
    }

    @Override
    @Nonnull
    public Either<AnError, ConfluencePage> find(CheckedUser user, Long pageId) {
        Either primaryAppLinkEither = this.serviceDeskAppLinkService.getPrimaryApplicationLinkForType(ConfluenceApplicationType.class);
        if (primaryAppLinkEither.isLeft()) {
            return Either.left((Object)primaryAppLinkEither.left().get());
        }
        ApplicationLink applicationLink = (ApplicationLink)primaryAppLinkEither.right().get();
        return this.find(user, applicationLink, pageId);
    }

    private Either<AnError, ConfluencePage> find(CheckedUser user, ApplicationLink applicationLink, Long pageId) {
        String applicationLinkId = applicationLink.getId().toString();
        List<ConfluenceKnowledgeBaseLink> allConfluenceKBLinksWithAppLinkId = this.confluenceKnowledgeBaseManager.getKbLinksBasedOnAppLinkId(applicationLinkId);
        ArrayList projectList = Lists.newArrayList();
        ArrayList applicableConfluenceKBLinks = Lists.newArrayList();
        for (ConfluenceKnowledgeBaseLink confluenceKBLink : allConfluenceKBLinksWithAppLinkId) {
            ServiceDesk serviceDesk;
            Project project;
            Either serviceDeskEither = this.serviceDeskService.getServiceDeskById(user, (long)confluenceKBLink.getServiceDeskId());
            if (serviceDeskEither.isLeft() || (project = this.projectManager.getProjectObj(Long.valueOf((serviceDesk = (ServiceDesk)serviceDeskEither.right().get()).getProjectId()))) == null) continue;
            projectList.add(project);
            applicableConfluenceKBLinks.add(confluenceKBLink);
        }
        if (projectList.isEmpty()) {
            return Either.left((Object)this.confluenceKbErrors.CONFLUENCE_PAGE_NOT_FOUND_ERROR());
        }
        Either pathEither = this.confluenceKnowledgeBaseService.getPagePath(pageId, applicationLink);
        if (pathEither.isLeft()) {
            return Either.left((Object)pathEither.left().get());
        }
        String path = (String)pathEither.right().get();
        Either confluencePageEither = this.serviceDeskAppLinkService.makeGetRequestForSomeProjects(user, (List)projectList, applicationLinkId, path, (BaseAppLinkResponseHandler)new ConfluencePageAppLinkResponseHandler(applicationLink, path, applicableConfluenceKBLinks, this.errorResultHelper, this.confluenceKbErrors, this.applicationLinkErrors));
        if (confluencePageEither.isLeft()) {
            return Either.left((Object)confluencePageEither.left().get());
        }
        ConfluencePage confluencePage = (ConfluencePage)confluencePageEither.right().get();
        String key = confluencePage.getConfluenceSpace().getKey();
        Option confluenceKBLinkOption = Iterables.findFirst((Iterable)applicableConfluenceKBLinks, confluenceKbLink -> StringUtils.isNotBlank((String)confluenceKbLink.getSpaceKey()) && confluenceKbLink.getSpaceKey().trim().equals(key));
        if (confluenceKBLinkOption.isEmpty()) {
            return Either.left((Object)this.confluenceKbErrors.CONFLUENCE_PAGE_NOT_FOUND_ERROR());
        }
        return Either.right((Object)confluencePage);
    }

    AnError toAnError(ServiceDeskHttpError error) {
        return Convert.toAnError(error, this.errorResultHelper);
    }
}

