/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.confluenceknowledgebase.search;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.servicedesk.internal.api.applink.ApplicationLinkErrors;
import com.atlassian.servicedesk.internal.api.applink.BaseAppLinkResponseHandler;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseLink;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.errors.ConfluenceKBErrors;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import org.codehaus.jackson.JsonNode;

public abstract class BaseConfluenceAppLinkResponseHandler<T>
extends BaseAppLinkResponseHandler<T> {
    protected final ConfluenceKBErrors confluenceKBErrors;

    protected BaseConfluenceAppLinkResponseHandler(ErrorResultHelper errorResultHelper, ConfluenceKBErrors confluenceKBErrors, ApplicationLinkErrors applicationLinkErrors) {
        super(applicationLinkErrors, errorResultHelper);
        this.confluenceKBErrors = confluenceKBErrors;
    }

    public Either<AnError, T> onResponseException(ResponseException responseException) {
        log.debug("A ResponseException was encountered communicating with Confluence with the following message: %s", (Object)responseException.getMessage());
        return Either.left((Object)this.confluenceKBErrors.CONFLUENCE_NOT_CONTACTABLE_ERROR());
    }

    public Either<AnError, T> onCredentialError(String responseBody) {
        log.error("Credential error encountered communicating with Confluence, possibly due to unsupported or misconfigured authentication settings: {}", (Object)responseBody);
        return Either.left((Object)this.applicationLinkErrors.INVALID_APP_LINK_CONFIGURATION());
    }

    public Either<AnError, T> onError(String responseBody, int statusCode) {
        log.error("Applink request has returned an error %s", (Object)responseBody);
        Option jsonObjectOption = this.toJsonObject(responseBody);
        if (jsonObjectOption.isEmpty()) {
            log.error("The response body from Confluence was empty, it returned statusCode {} and response: {}", (Object)statusCode, (Object)responseBody);
            return Either.left((Object)this.confluenceKBErrors.CONFLUENCE_COMMUNICATION_ERROR());
        }
        JsonNode jsonObject = (JsonNode)jsonObjectOption.get();
        if (jsonObject.has("statusCode") && statusCode == Response.Status.NOT_FOUND.getStatusCode()) {
            log.error("Confluence could not find the requested page and returned a 404.");
            return Either.left((Object)this.errorResultHelper.notFound404("sd.kb.page.not.found", new Object[0]).build());
        }
        log.error("An error was encountered communicating with Confluence, it returned statusCode {} and response: {}", (Object)statusCode, (Object)responseBody);
        return Either.left((Object)this.applicationLinkErrors.FAILED_REQUEST());
    }

    @Nonnull
    protected Either<AnError, String> getRemoteUrl(ApplicationLink applicationLink, Long pageId) {
        URI rpcUrl = applicationLink.getRpcUrl();
        ApplicationId id = applicationLink.getId();
        if (rpcUrl == null || id == null) {
            log.debug("Could not get the remoteURL for confluence page with ID {} because the application link has a null base URL ({}) or ID ({})", new Object[]{pageId, rpcUrl, id});
            return Either.left((Object)this.applicationLinkErrors.INVALID_APP_LINK());
        }
        return this.getRemoteUrl(rpcUrl.toString(), pageId, id.toString());
    }

    @Nonnull
    protected Either<AnError, String> getRemoteUrl(String baseUrl, Long pageId, String applicationLinkId) {
        try {
            return Either.right((Object)UriBuilder.fromUri((String)baseUrl).path("/plugins/servlet/remotepageview").queryParam("pageId", new Object[]{pageId}).build(new Object[0]).toString());
        }
        catch (IllegalArgumentException | UriBuilderException ex) {
            log.error("Unexpected error building URI from confluence app link settings, check the URL for the applink with ID {}: {}", (Object)applicationLinkId, (Object)baseUrl);
            return Either.left((Object)this.applicationLinkErrors.INVALID_APP_LINK_CONFIGURATION());
        }
    }

    @Nonnull
    protected Either<AnError, String> getRemoteUrl(ConfluenceKnowledgeBaseLink confluenceKBLink, Long pageId) {
        return this.getRemoteUrl(confluenceKBLink.getApplicationUrl(), pageId, confluenceKBLink.getApplicationId());
    }
}

