/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.confluenceknowledgebase.kblink;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseLink;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.ConfluenceKnowledgeBaseLinkImpl;
import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.google.common.collect.Lists;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class ConfluenceKBLinkQStore {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceKBLinkQStore.class);
    private final DatabaseAccessor databaseAccessor;

    @Autowired
    public ConfluenceKBLinkQStore(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
    }

    public Option<ConfluenceKnowledgeBaseLink> addKBLink(ConfluenceKnowledgeBaseLink confluenceKBLink) {
        return (Option)this.databaseAccessor.runInTransaction(conn -> this.createKBLink(confluenceKBLink, (DatabaseConnection)conn));
    }

    public Option<ConfluenceKnowledgeBaseLink> getKBLinkForServiceDesk(int serviceDeskId) {
        return (Option)this.databaseAccessor.runInTransaction(conn -> this.getKBLinkForServiceDesk(serviceDeskId, (DatabaseConnection)conn));
    }

    public Option<ConfluenceKnowledgeBaseLink> updateKBLink(ConfluenceKnowledgeBaseLink updatedConfluenceLink) {
        return (Option)this.databaseAccessor.runInTransaction(conn -> this.updateKBLink(updatedConfluenceLink, (DatabaseConnection)conn));
    }

    public List<ConfluenceKnowledgeBaseLink> getAllKbLinks() {
        return (List)this.databaseAccessor.runInTransaction(conn -> this.getAllKbLinks((DatabaseConnection)conn));
    }

    public List<ConfluenceKnowledgeBaseLink> getAllKbLinks(DatabaseConnection databaseConnection) {
        List tuples = ((SQLQuery)databaseConnection.select((Expression[])Tables.CONFLUENCE_KB.all()).from((Expression)Tables.CONFLUENCE_KB)).fetch();
        return this.tuplesToKbList(tuples);
    }

    public List<ConfluenceKnowledgeBaseLink> getKBLinkOfServiceDesks(List<Integer> idList) {
        List tuples = (List)this.databaseAccessor.runInTransaction(conn -> ((SQLQuery)((SQLQuery)((SQLQuery)conn.select((Expression[])Tables.CONFLUENCE_KB.all()).from((Expression)Tables.CONFLUENCE_KB)).where((Predicate)Tables.CONFLUENCE_KB.SERVICE_DESK_ID.in((Collection)idList))).orderBy(Tables.CONFLUENCE_KB.SERVICE_DESK_ID.asc())).fetch());
        return this.tuplesToKbList(tuples);
    }

    public List<ConfluenceKnowledgeBaseLink> getKbLinkBasedOnAppLinkIdAndServiceDeskIds(String appLinkId, List<Integer> idList) {
        List tuples = (List)this.databaseAccessor.runInTransaction(conn -> ((SQLQuery)((SQLQuery)((SQLQuery)conn.select((Expression[])Tables.CONFLUENCE_KB.all()).from((Expression)Tables.CONFLUENCE_KB)).where((Predicate)Tables.CONFLUENCE_KB.APPLINKS_APPLICATION_ID.eq((Object)appLinkId).and((Predicate)Tables.CONFLUENCE_KB.SERVICE_DESK_ID.in((Collection)idList)))).orderBy(Tables.CONFLUENCE_KB.SERVICE_DESK_ID.asc())).fetch());
        return this.tuplesToKbList(tuples);
    }

    public List<ConfluenceKnowledgeBaseLink> getKbLinksBasedOnApplicationLinkId(String appLinkId) {
        List tuples = (List)this.databaseAccessor.runInTransaction(conn -> ((SQLQuery)((SQLQuery)((SQLQuery)conn.select((Expression[])Tables.CONFLUENCE_KB.all()).from((Expression)Tables.CONFLUENCE_KB)).where((Predicate)Tables.CONFLUENCE_KB.APPLINKS_APPLICATION_ID.eq((Object)appLinkId))).orderBy(Tables.CONFLUENCE_KB.SERVICE_DESK_ID.asc())).fetch());
        return this.tuplesToKbList(tuples);
    }

    public List<ConfluenceKnowledgeBaseLink> getKBLinksBySpaceKey(String spaceKey) {
        List tuples = (List)this.databaseAccessor.runInTransaction(conn -> ((SQLQuery)((SQLQuery)conn.select((Expression[])Tables.CONFLUENCE_KB.all()).from((Expression)Tables.CONFLUENCE_KB)).where((Predicate)Tables.CONFLUENCE_KB.SPACE_KEY.eq((Object)spaceKey))).fetch());
        return this.tuplesToKbList(tuples);
    }

    private Option<ConfluenceKnowledgeBaseLink> updateKBLink(ConfluenceKnowledgeBaseLink updatedConfluenceLink, DatabaseConnection databaseConnection) {
        long numberOfRowsUpdated = databaseConnection.update((RelationalPath)Tables.CONFLUENCE_KB).where((Predicate)Tables.CONFLUENCE_KB.ID.eq((Object)updatedConfluenceLink.getId())).set((Path)Tables.CONFLUENCE_KB.APPLINKS_APPLICATION_ID, (Object)updatedConfluenceLink.getApplicationId()).set((Path)Tables.CONFLUENCE_KB.APPLINK_NAME, (Object)updatedConfluenceLink.getApplicationName()).set((Path)Tables.CONFLUENCE_KB.APPLINK_URL, (Object)updatedConfluenceLink.getApplicationUrl()).set((Path)Tables.CONFLUENCE_KB.SPACE_KEY, (Object)updatedConfluenceLink.getSpaceKey()).set((Path)Tables.CONFLUENCE_KB.SPACE_NAME, (Object)updatedConfluenceLink.getSpaceName()).set((Path)Tables.CONFLUENCE_KB.SPACE_URL, (Object)updatedConfluenceLink.getSpaceUrl()).set(Tables.CONFLUENCE_KB.SERVICE_DESK_ID, (Object)updatedConfluenceLink.getServiceDeskId()).execute();
        if (numberOfRowsUpdated != 1L) {
            throw new RuntimeException(String.format("Expected %d row to be updated, but %d updated", 1, numberOfRowsUpdated));
        }
        return this.getKBLink(updatedConfluenceLink.getId(), databaseConnection);
    }

    public void deleteKBLink(int serviceDeskId, DatabaseConnection databaseConnection) {
        long numberOfRowsDeleted = databaseConnection.delete((RelationalPath)Tables.CONFLUENCE_KB).where((Predicate)Tables.CONFLUENCE_KB.SERVICE_DESK_ID.eq((Object)serviceDeskId)).execute();
        if (numberOfRowsDeleted != 1L) {
            log.warn(String.format("Expected %d row to be removed, but %d removed", 1, numberOfRowsDeleted));
        }
    }

    private Option<ConfluenceKnowledgeBaseLink> getKBLinkForServiceDesk(int serviceDeskId, DatabaseConnection databaseConnection) {
        Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)databaseConnection.select((Expression[])Tables.CONFLUENCE_KB.all()).from((Expression)Tables.CONFLUENCE_KB)).where((Predicate)Tables.CONFLUENCE_KB.SERVICE_DESK_ID.eq((Object)serviceDeskId))).fetchFirst();
        return Option.option((Object)tuple).flatMap(this::tupleToKBLink);
    }

    private Option<ConfluenceKnowledgeBaseLink> getKBLink(int id, DatabaseConnection databaseConnection) {
        Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)databaseConnection.select((Expression[])Tables.CONFLUENCE_KB.all()).from((Expression)Tables.CONFLUENCE_KB)).where((Predicate)Tables.CONFLUENCE_KB.ID.eq((Object)id))).fetchFirst();
        return Option.option((Object)tuple).flatMap(this::tupleToKBLink);
    }

    private Option<ConfluenceKnowledgeBaseLink> createKBLink(ConfluenceKnowledgeBaseLink confluenceKBLink, DatabaseConnection databaseConnection) {
        Integer newId = (Integer)databaseConnection.insert((RelationalPath)Tables.CONFLUENCE_KB).set((Path)Tables.CONFLUENCE_KB.APPLINKS_APPLICATION_ID, (Object)confluenceKBLink.getApplicationId()).set((Path)Tables.CONFLUENCE_KB.APPLINK_NAME, (Object)confluenceKBLink.getApplicationName()).set((Path)Tables.CONFLUENCE_KB.APPLINK_URL, (Object)confluenceKBLink.getApplicationUrl()).set((Path)Tables.CONFLUENCE_KB.SPACE_KEY, (Object)confluenceKBLink.getSpaceKey()).set((Path)Tables.CONFLUENCE_KB.SPACE_NAME, (Object)confluenceKBLink.getSpaceName()).set((Path)Tables.CONFLUENCE_KB.SPACE_URL, (Object)confluenceKBLink.getSpaceUrl()).set(Tables.CONFLUENCE_KB.SERVICE_DESK_ID, (Object)confluenceKBLink.getServiceDeskId()).executeWithKey(Tables.CONFLUENCE_KB.ID);
        return Option.option((Object)newId).flatMap(nonNullId -> this.getKBLink((int)nonNullId, databaseConnection));
    }

    private Option<ConfluenceKnowledgeBaseLink> tupleToKBLink(Tuple tuple) {
        return Steps.begin(this.getNonNullValue(tuple, (Expression)Tables.CONFLUENCE_KB.ID, "ID")).then(id -> this.getNonNullValue(tuple, (Expression)Tables.CONFLUENCE_KB.SERVICE_DESK_ID, "SERVICEDESK_ID")).yield((id, serviceDeskId) -> {
            String appLinkId = (String)Option.option((Object)tuple.get((Expression)Tables.CONFLUENCE_KB.APPLINKS_APPLICATION_ID)).getOrElse((Object)"");
            String appLinkUrl = (String)Option.option((Object)tuple.get((Expression)Tables.CONFLUENCE_KB.APPLINK_URL)).getOrElse((Object)"");
            String appLinkName = (String)Option.option((Object)tuple.get((Expression)Tables.CONFLUENCE_KB.APPLINK_NAME)).getOrElse((Object)"");
            String spaceKey = (String)Option.option((Object)tuple.get((Expression)Tables.CONFLUENCE_KB.SPACE_KEY)).getOrElse((Object)"");
            String spaceName = (String)Option.option((Object)tuple.get((Expression)Tables.CONFLUENCE_KB.SPACE_NAME)).getOrElse((Object)"");
            String spaceUrl = (String)Option.option((Object)tuple.get((Expression)Tables.CONFLUENCE_KB.SPACE_URL)).getOrElse((Object)"");
            return new ConfluenceKnowledgeBaseLinkImpl((int)id, (int)serviceDeskId, appLinkId, appLinkName, appLinkUrl, spaceKey, spaceName, spaceUrl);
        });
    }

    private List<ConfluenceKnowledgeBaseLink> tuplesToKbList(List<Tuple> tupleList) {
        return tupleList.stream().flatMap(tuple -> Lists.newArrayList((Iterator)this.tupleToKBLink((Tuple)tuple).iterator()).stream()).collect(Collectors.toList());
    }

    private <T> Option<T> getNonNullValue(Tuple tuple, Expression<T> expr, String columnName) {
        Option value = Option.option((Object)tuple.get(expr));
        if (value.isEmpty()) {
            log.error("Retrieved KB link has a null {} when it's expected to be non-null", (Object)columnName);
        }
        return value;
    }
}

