/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.comment;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.comment.CreateInternalCommentParameters;
import com.atlassian.servicedesk.api.comment.CreatePublicCommentParameters;
import com.atlassian.servicedesk.api.comment.ServiceDeskComment;
import com.atlassian.servicedesk.api.comment.ServiceDeskCommentCreateParameters;
import com.atlassian.servicedesk.api.comment.ServiceDeskCommentQuery;
import com.atlassian.servicedesk.api.comment.ServiceDeskCommentService;
import com.atlassian.servicedesk.api.comment.ValidatedInternalCommentParameters;
import com.atlassian.servicedesk.api.comment.ValidatedPublicCommentParameters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequest;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import com.atlassian.servicedesk.api.util.paging.PagedResponseImpl;
import com.atlassian.servicedesk.internal.comment.InternalSDCommentService;
import com.atlassian.servicedesk.internal.comment.InternalServiceDeskCommentService;
import com.atlassian.servicedesk.internal.comment.ServiceDeskCommentCreateParametersImpl;
import com.atlassian.servicedesk.internal.comment.ServiceDeskCommentQueryImpl;
import com.atlassian.servicedesk.internal.comment.ServiceDeskCommentUtil;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class ServiceDeskCommentServiceImpl
implements ServiceDeskCommentService {
    private final InternalServiceDeskCommentService serviceDeskInternalCommentService;
    private final InternalSDCommentService internalSDCommentService;
    private final UserFactory userFactory;

    @Autowired
    public ServiceDeskCommentServiceImpl(InternalServiceDeskCommentService serviceDeskInternalCommentService, InternalSDCommentService internalSDCommentService, UserFactory userFactory) {
        this.serviceDeskInternalCommentService = serviceDeskInternalCommentService;
        this.internalSDCommentService = internalSDCommentService;
        this.userFactory = userFactory;
    }

    @Nonnull
    public Either<AnError, ValidatedPublicCommentParameters> validatePublicComment(@Nonnull ApplicationUser user, @Nonnull CreatePublicCommentParameters publicCommentParameters) {
        return Steps.begin((Either)this.userFactory.wrap(user)).then(checkedUser -> StepsConverters.olderEither(this.internalSDCommentService.validatePublicCommentParamsAnErrorIfValidationFails((CheckedUser)checkedUser, publicCommentParameters))).yield((checkedUser, commentCreateValidationResult) -> new ValidatedPublicCommentParametersImpl((CommentService.CommentCreateValidationResult)commentCreateValidationResult, publicCommentParameters.shouldDispatchEvent()));
    }

    @Nonnull
    public Either<AnError, ValidatedInternalCommentParameters> validateInternalComment(@Nonnull ApplicationUser user, @Nonnull CreateInternalCommentParameters internalCommentParameters) {
        return Steps.begin((Either)this.userFactory.wrap(user)).then(checkedUser -> StepsConverters.olderEither(this.internalSDCommentService.validateInternalCommentParamsAnErrorIfValidationFails((CheckedUser)checkedUser, internalCommentParameters))).yield((checkedUser, commentCreateValidationResult) -> new ValidatedInternalCommentParametersImpl((CommentService.CommentCreateValidationResult)commentCreateValidationResult, internalCommentParameters.shouldDispatchEvent()));
    }

    @Nonnull
    public Either<AnError, ServiceDeskComment> createPublicComment(@Nonnull ApplicationUser user, @Nonnull ValidatedPublicCommentParameters validatedPublicCommentParameters) {
        ValidatedPublicCommentParametersImpl validationResult = (ValidatedPublicCommentParametersImpl)validatedPublicCommentParameters;
        return Steps.begin((Either)this.userFactory.wrap(user)).then(checkedUser -> StepsConverters.olderEither(this.internalSDCommentService.createComment((CheckedUser)checkedUser, validationResult.getCommentCreateValidationResult(), validationResult.getShouldDispatchEvent()))).yield((checkedUser, sdComment) -> ServiceDeskCommentUtil.convertToServiceDeskCommentWithoutAttachments(sdComment));
    }

    @Nonnull
    public Either<AnError, ServiceDeskComment> createInternalComment(@Nonnull ApplicationUser user, @Nonnull ValidatedInternalCommentParameters validatedInternalCommentParameters) {
        ValidatedInternalCommentParametersImpl validatedResult = (ValidatedInternalCommentParametersImpl)validatedInternalCommentParameters;
        return Steps.begin((Either)this.userFactory.wrap(user)).then(checkedUser -> StepsConverters.olderEither(this.internalSDCommentService.createComment((CheckedUser)checkedUser, validatedResult.getCommentCreateValidationResult(), validatedResult.getShouldDispatchEvent()))).yield((checkedUser, sdComment) -> ServiceDeskCommentUtil.convertToServiceDeskCommentWithoutAttachments(sdComment));
    }

    @Nonnull
    public Either<AnError, ServiceDeskComment> getServiceDeskCommentById(@Nonnull ApplicationUser user, @Nonnull Long commentId) {
        return Steps.begin((Either)this.userFactory.wrap(user)).then(checkedUser -> StepsConverters.olderEither(this.internalSDCommentService.getSDCommentById((CheckedUser)checkedUser, commentId))).yield((checkedUser, sdComment) -> ServiceDeskCommentUtil.convertToServiceDeskCommentWithoutAttachments(sdComment));
    }

    @Nonnull
    public Either<AnError, ServiceDeskComment> getServiceDeskCommentByJiraComment(@Nonnull ApplicationUser user, @Nonnull Comment jiraComment) {
        return Steps.begin((Either)this.userFactory.wrap(user)).then(checkedUser -> StepsConverters.olderEither(this.internalSDCommentService.getSDCommentForComment((CheckedUser)checkedUser, jiraComment))).yield((checkedUser, sdComment) -> ServiceDeskCommentUtil.convertToServiceDeskCommentWithoutAttachments(sdComment));
    }

    public ServiceDeskCommentCreateParameters.Builder newCreateBuilder() {
        return ServiceDeskCommentCreateParametersImpl.builder();
    }

    @Nonnull
    public Either<AnError, ServiceDeskComment> createServiceDeskComment(@Nonnull ApplicationUser user, @Nonnull ServiceDeskCommentCreateParameters createParameters) {
        return Steps.begin((Either)this.userFactory.wrap(user)).then(cu -> StepsConverters.olderEither(this.serviceDeskInternalCommentService.createServiceDeskComment((CheckedUser)cu, createParameters))).yield((cu, c) -> c);
    }

    public ServiceDeskCommentQuery.Builder newQueryBuilder() {
        return ServiceDeskCommentQueryImpl.newBuilder();
    }

    @Nonnull
    public Either<AnError, PagedResponse<ServiceDeskComment>> getCommentsOfRequest(@Nonnull ApplicationUser user, @Nonnull ServiceDeskCommentQuery queryParameters) {
        return Steps.begin((Either)this.userFactory.wrap(user)).then(checkedUser -> this.getServiceDeskCommentsByIssue((CheckedUser)checkedUser, queryParameters.issue())).then((checkedUser, serviceDeskComments) -> this.filterBasedOnVisibility((List<ServiceDeskComment>)serviceDeskComments, queryParameters)).yield((checkedUser, serviceDeskComments, filteredComment) -> PagedResponseImpl.toPagedResponse((LimitedPagedRequest)queryParameters.pagedRequest(), (List)filteredComment));
    }

    private Either<AnError, List<ServiceDeskComment>> getServiceDeskCommentsByIssue(CheckedUser checkedUser, Issue issue) {
        Either sdComments = StepsConverters.olderEither(this.internalSDCommentService.getSDCommentsByIssue(checkedUser, issue));
        return sdComments.map(list -> list.stream().map(ServiceDeskCommentUtil::convertToServiceDeskCommentWithoutAttachments).collect(Collectors.toList()));
    }

    private Either<AnError, List<ServiceDeskComment>> filterBasedOnVisibility(List<ServiceDeskComment> comments, ServiceDeskCommentQuery query) {
        return Either.right(comments.stream().filter(comment -> this.shouldIncludeComment((ServiceDeskComment)comment, query)).collect(Collectors.toList()));
    }

    @VisibleForTesting
    boolean shouldIncludeComment(ServiceDeskComment comment, ServiceDeskCommentQuery query) {
        return query.publicComment() && comment.isPublic() || query.internalComment() && !comment.isPublic();
    }

    private class ValidatedInternalCommentParametersImpl
    implements ValidatedInternalCommentParameters {
        private final CommentService.CommentCreateValidationResult commentCreateValidationResult;
        private final boolean dispatchEvent;

        ValidatedInternalCommentParametersImpl(CommentService.CommentCreateValidationResult commentCreateValidationResult, boolean dispatchEvent) {
            this.commentCreateValidationResult = commentCreateValidationResult;
            this.dispatchEvent = dispatchEvent;
        }

        CommentService.CommentCreateValidationResult getCommentCreateValidationResult() {
            return this.commentCreateValidationResult;
        }

        boolean getShouldDispatchEvent() {
            return this.dispatchEvent;
        }
    }

    private class ValidatedPublicCommentParametersImpl
    implements ValidatedPublicCommentParameters {
        private final CommentService.CommentCreateValidationResult commentCreateValidationResult;
        private final boolean dispatchEvent;

        ValidatedPublicCommentParametersImpl(CommentService.CommentCreateValidationResult commentCreateValidationResult, boolean dispatchEvent) {
            this.commentCreateValidationResult = commentCreateValidationResult;
            this.dispatchEvent = dispatchEvent;
        }

        CommentService.CommentCreateValidationResult getCommentCreateValidationResult() {
            return this.commentCreateValidationResult;
        }

        boolean getShouldDispatchEvent() {
            return this.dispatchEvent;
        }
    }
}

