/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.comment;

import com.atlassian.jira.issue.Issue;
import com.atlassian.servicedesk.api.comment.ServiceDeskCommentQuery;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequest;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequestImpl;
import com.atlassian.servicedesk.api.util.paging.PagedRequest;
import io.atlassian.fugue.Option;

public class ServiceDeskCommentQueryImpl
implements ServiceDeskCommentQuery {
    private final Issue issue;
    private final LimitedPagedRequest pagedRequest;
    private final boolean publicComment;
    private final boolean internalComment;

    private ServiceDeskCommentQueryImpl(Issue issue, LimitedPagedRequest pagedRequest, boolean publicComment, boolean internalComment) {
        this.issue = issue;
        this.pagedRequest = pagedRequest;
        this.publicComment = publicComment;
        this.internalComment = internalComment;
    }

    public Issue issue() {
        return this.issue;
    }

    public LimitedPagedRequest pagedRequest() {
        return this.pagedRequest;
    }

    public boolean publicComment() {
        return this.publicComment;
    }

    public boolean internalComment() {
        return this.internalComment;
    }

    static ServiceDeskCommentQuery.Builder newBuilder() {
        return new ServiceDeskCommentQueryBuilderImpl();
    }

    private static final class ServiceDeskCommentQueryBuilderImpl
    implements ServiceDeskCommentQuery.Builder {
        private Issue issue;
        private LimitedPagedRequest pagedRequest = LimitedPagedRequestImpl.create((int)50);
        private boolean publicComment = true;
        private boolean internalComment = true;

        private ServiceDeskCommentQueryBuilderImpl() {
        }

        public ServiceDeskCommentQuery.Builder issue(Issue issue) {
            this.issue = issue;
            return this;
        }

        public ServiceDeskCommentQuery.Builder pagedRequest(PagedRequest pagedRequest) {
            this.pagedRequest = LimitedPagedRequestImpl.create((PagedRequest)pagedRequest, (int)50);
            return this;
        }

        public ServiceDeskCommentQuery.Builder internalComment(Boolean internalComment) {
            this.internalComment = (Boolean)Option.option((Object)internalComment).getOrElse((Object)true);
            return this;
        }

        public ServiceDeskCommentQuery.Builder publicComment(Boolean publicComment) {
            this.publicComment = (Boolean)Option.option((Object)publicComment).getOrElse((Object)true);
            return this;
        }

        public ServiceDeskCommentQuery build() {
            return new ServiceDeskCommentQueryImpl(this.issue, this.pagedRequest, this.publicComment, this.internalComment);
        }
    }
}

